/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.solver.simple.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.solver.move.TravelingTournamentMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayChangeMove
implements Move {
    private Match match;
    private Day toDay;

    public DayChangeMove(Match match, Day toDay) {
        this.match = match;
        this.toDay = toDay;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.match.getDay(), (Object)this.toDay);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new DayChangeMove(this.match, this.match.getDay());
    }

    public void doMove(ScoreDirector scoreDirector) {
        TravelingTournamentMoveHelper.moveDay(scoreDirector, this.match, this.toDay);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.match);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toDay);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DayChangeMove) {
            DayChangeMove other = (DayChangeMove)o;
            return new EqualsBuilder().append((Object)this.match, (Object)other.match).append((Object)this.toDay, (Object)other.toDay).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.match).append((Object)this.toDay).toHashCode();
    }

    public String toString() {
        return this.match + " => " + this.toDay;
    }
}

