/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.drools.planner.examples.common.swingui.TangoColors;
import org.drools.planner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.Domicile;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.domain.Visit;
import org.drools.planner.examples.tsp.swingui.TspPanel;

public class TspWorldPanel
extends JPanel {
    private static final int TEXT_SIZE = 8;
    private final TspPanel tspPanel;
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;
    private ImageIcon europaBackground;

    public TspWorldPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TravelingSalesmanTour travelingSalesmanTour = TspWorldPanel.this.tspPanel.getTravelingSalesmanTour();
                if (travelingSalesmanTour != null) {
                    TspWorldPanel.this.resetPanel(travelingSalesmanTour);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (TspWorldPanel.this.translator != null) {
                    double longitude = TspWorldPanel.this.translator.translateXToLongitude(e.getX());
                    double latitude = TspWorldPanel.this.translator.translateYToLatitude(e.getY());
                    TspWorldPanel.this.tspPanel.insertCityAndVisit(longitude, latitude);
                }
            }
        });
        this.europaBackground = new ImageIcon(this.getClass().getResource("/org/drools/planner/examples/tsp/swingui/europaBackground.png"));
    }

    public void resetPanel(TravelingSalesmanTour travelingSalesmanTour) {
        int y;
        int x;
        City city;
        this.translator = new LatitudeLongitudeTranslator();
        for (City city2 : travelingSalesmanTour.getCityList()) {
            this.translator.addCoordinates(city2.getLatitude(), city2.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height);
        Graphics g = this.createCanvas(width, height);
        String tourName = travelingSalesmanTour.getName();
        if (tourName.startsWith("europe")) {
            g.drawImage(this.europaBackground.getImage(), 0, 0, this.translator.getImageWidth(), this.translator.getImageHeight(), this);
        }
        g.setFont(g.getFont().deriveFont(8.0f));
        g.setColor(TangoColors.PLUM_2);
        for (Visit visit : travelingSalesmanTour.getVisitList()) {
            city = visit.getCity();
            x = this.translator.translateLongitudeToX(city.getLongitude());
            y = this.translator.translateLatitudeToY(city.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
            if (city.getName() == null) continue;
            g.drawString(city.getName(), x + 3, y - 3);
        }
        g.setColor(TangoColors.ALUMINIUM_4);
        for (Domicile domicile : travelingSalesmanTour.getDomicileList()) {
            city = domicile.getCity();
            x = this.translator.translateLongitudeToX(city.getLongitude());
            y = this.translator.translateLatitudeToY(city.getLatitude());
            g.fillRect(x - 2, y - 2, 5, 5);
            if (city.getName() == null) continue;
            g.drawString(city.getName(), x + 3, y - 3);
        }
        g.setColor(TangoColors.CHOCOLATE_1);
        for (Visit visit : travelingSalesmanTour.getVisitList()) {
            if (visit.getPreviousAppearance() == null) continue;
            City previousCity = visit.getPreviousAppearance().getCity();
            int previousX = this.translator.translateLongitudeToX(previousCity.getLongitude());
            int previousY = this.translator.translateLatitudeToY(previousCity.getLatitude());
            City city3 = visit.getCity();
            int x2 = this.translator.translateLongitudeToX(city3.getLongitude());
            int y2 = this.translator.translateLatitudeToY(city3.getLatitude());
            g.drawLine(previousX, previousY, x2, y2);
            boolean needsBackToDomicileLineDraw = true;
            for (Visit trailingVisit : travelingSalesmanTour.getVisitList()) {
                if (trailingVisit.getPreviousAppearance() != visit) continue;
                needsBackToDomicileLineDraw = false;
                break;
            }
            if (!needsBackToDomicileLineDraw) continue;
            Domicile domicile = travelingSalesmanTour.getDomicileList().get(0);
            City domicileCity = domicile.getCity();
            int domicileX = this.translator.translateLongitudeToX(domicileCity.getLongitude());
            int domicileY = this.translator.translateLatitudeToY(domicileCity.getLatitude());
            g.drawLine(x2, y2, domicileX, domicileY);
        }
        g.setColor(TangoColors.ALUMINIUM_4);
        g.fillRect(5, (int)height - 20, 5, 5);
        g.drawString("Domicile", 15, (int)height - 15);
        g.setColor(TangoColors.PLUM_2);
        g.fillRect(6, (int)height - 9, 3, 3);
        g.drawString("Visit", 15, (int)height - 5);
        this.repaint();
    }

    public void updatePanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.resetPanel(travelingSalesmanTour);
    }

    private Graphics createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

