/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.common.domain.AbstractPersistable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="CloudBalance")
public class CloudBalance
extends AbstractPersistable
implements Solution<HardAndSoftScore> {
    private List<CloudComputer> computerList;
    private List<CloudProcess> processList;
    private HardAndSoftScore score;

    public List<CloudComputer> getComputerList() {
        return this.computerList;
    }

    public void setComputerList(List<CloudComputer> computerList) {
        this.computerList = computerList;
    }

    @PlanningEntityCollectionProperty
    public List<CloudProcess> getProcessList() {
        return this.processList;
    }

    public void setProcessList(List<CloudProcess> processList) {
        this.processList = processList;
    }

    public HardAndSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardAndSoftScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<CloudComputer> facts = new ArrayList<CloudComputer>();
        facts.addAll(this.computerList);
        return facts;
    }

    public CloudBalance cloneSolution() {
        CloudBalance clone = new CloudBalance();
        clone.id = this.id;
        clone.computerList = this.computerList;
        ArrayList<CloudProcess> clonedProcessList = new ArrayList<CloudProcess>(this.processList.size());
        for (CloudProcess process : this.processList) {
            CloudProcess clonedProcess = process.clone();
            clonedProcessList.add(clonedProcess);
        }
        clone.processList = clonedProcessList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CloudBalance)) {
            return false;
        }
        CloudBalance other = (CloudBalance)o;
        if (this.processList.size() != other.processList.size()) {
            return false;
        }
        Iterator<CloudProcess> it = this.processList.iterator();
        Iterator<CloudProcess> otherIt = other.processList.iterator();
        while (it.hasNext()) {
            CloudProcess otherProcess;
            CloudProcess process = it.next();
            if (process.solutionEquals(otherProcess = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CloudProcess process : this.processList) {
            hashCodeBuilder.append(process.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

