/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.swingui.CloudBalancingPanel;
import org.drools.planner.examples.common.swingui.TangoColors;

public class CloudComputerPanel
extends JPanel {
    private final CloudBalancingPanel cloudBalancingPanel;
    private CloudComputer computer;
    private List<CloudProcess> processList = new ArrayList<CloudProcess>();
    private JLabel computerLabel;
    private JButton deleteButton;
    private JTextField cpuPowerField;
    private JTextField memoryField;
    private JTextField networkBandwidthField;
    private JTextField costField;
    private JLabel numberOfProcessesLabel;
    private CloudBar cpuPowerBar;
    private CloudBar memoryBar;
    private CloudBar networkBandwidthBar;
    private JButton detailsButton;

    public CloudComputerPanel(CloudBalancingPanel cloudBalancingPanel, CloudComputer computer) {
        super(new GridLayout(0, 5));
        this.cloudBalancingPanel = cloudBalancingPanel;
        this.computer = computer;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.BLACK)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.createTotalsUI();
        this.createBarsUI();
    }

    public CloudComputer getComputer() {
        return this.computer;
    }

    private String getComputerLabel() {
        return this.computer == null ? "Unassigned" : this.computer.getLabel();
    }

    private int getComputerCpuPower() {
        return this.computer == null ? 0 : this.computer.getCpuPower();
    }

    private int getComputerMemory() {
        return this.computer == null ? 0 : this.computer.getMemory();
    }

    private int getComputerNetworkBandwidth() {
        return this.computer == null ? 0 : this.computer.getNetworkBandwidth();
    }

    private int getComputerCost() {
        return this.computer == null ? 0 : this.computer.getCost();
    }

    private void createTotalsUI() {
        JPanel labelAndDeletePanel = new JPanel(new BorderLayout());
        this.computerLabel = new JLabel(this.getComputerLabel());
        this.computerLabel.setEnabled(false);
        labelAndDeletePanel.add((Component)this.computerLabel, "Center");
        if (this.computer != null) {
            this.deleteButton = new JButton(new AbstractAction("X"){

                public void actionPerformed(ActionEvent e) {
                    CloudComputerPanel.this.cloudBalancingPanel.deleteComputer(CloudComputerPanel.this.computer);
                }
            });
            labelAndDeletePanel.add((Component)this.deleteButton, "East");
        }
        this.add(labelAndDeletePanel);
        this.cpuPowerField = new JTextField("0 GHz / " + this.getComputerCpuPower() + " GHz");
        this.cpuPowerField.setEditable(false);
        this.cpuPowerField.setEnabled(false);
        this.add(this.cpuPowerField);
        this.memoryField = new JTextField("0 GB / " + this.getComputerMemory() + " GB");
        this.memoryField.setEditable(false);
        this.memoryField.setEnabled(false);
        this.add(this.memoryField);
        this.networkBandwidthField = new JTextField("0 GB / " + this.getComputerNetworkBandwidth() + " GB");
        this.networkBandwidthField.setEditable(false);
        this.networkBandwidthField.setEnabled(false);
        this.add(this.networkBandwidthField);
        this.costField = new JTextField(this.getComputerCost() + " $");
        this.costField.setEditable(false);
        this.costField.setEnabled(false);
        this.add(this.costField);
    }

    private void createBarsUI() {
        this.numberOfProcessesLabel = new JLabel("    0 processes");
        this.numberOfProcessesLabel.setEnabled(false);
        this.add(this.numberOfProcessesLabel);
        this.cpuPowerBar = new CloudBar(this.getComputerCpuPower(), this.cloudBalancingPanel.getMaximumComputerCpuPower());
        this.cpuPowerBar.setEnabled(false);
        this.add(this.cpuPowerBar);
        this.memoryBar = new CloudBar(this.getComputerMemory(), this.cloudBalancingPanel.getMaximumComputerMemory());
        this.memoryBar.setEnabled(false);
        this.add(this.memoryBar);
        this.networkBandwidthBar = new CloudBar(this.getComputerNetworkBandwidth(), this.cloudBalancingPanel.getMaximumComputerNetworkBandwidth());
        this.networkBandwidthBar.setEnabled(false);
        this.add(this.networkBandwidthBar);
        this.detailsButton = new JButton(new AbstractAction("Details"){

            public void actionPerformed(ActionEvent e) {
                CloudProcessListDialog processListDialog = new CloudProcessListDialog();
                processListDialog.setLocationRelativeTo(CloudComputerPanel.this.getRootPane());
                processListDialog.setVisible(true);
            }
        });
        this.detailsButton.setEnabled(false);
        this.add(this.detailsButton);
    }

    public void addProcess(CloudProcess process) {
        this.processList.add(process);
    }

    public void removeProcess(CloudProcess process) {
        this.processList.remove(process);
    }

    public void clearProcess() {
        this.processList.clear();
    }

    public void update() {
        int usedCpuPower = 0;
        this.cpuPowerBar.clearProcessValues();
        int usedMemory = 0;
        this.memoryBar.clearProcessValues();
        int usedNetworkBandwidth = 0;
        this.networkBandwidthBar.clearProcessValues();
        int colorIndex = 0;
        for (CloudProcess process : this.processList) {
            usedCpuPower += process.getRequiredCpuPower();
            this.cpuPowerBar.addProcessValue(process.getRequiredCpuPower());
            usedMemory += process.getRequiredMemory();
            this.memoryBar.addProcessValue(process.getRequiredMemory());
            usedNetworkBandwidth += process.getRequiredNetworkBandwidth();
            this.networkBandwidthBar.addProcessValue(process.getRequiredNetworkBandwidth());
            colorIndex = (colorIndex + 1) % TangoColors.SEQUENCE_1.length;
        }
        boolean used = this.processList.size() > 0;
        this.updateTotals(usedCpuPower, usedMemory, usedNetworkBandwidth, used);
        this.updateBars(used);
    }

    private void updateTotals(int usedCpuPower, int usedMemory, int usedNetworkBandwidth, boolean used) {
        this.computerLabel.setEnabled(used);
        this.cpuPowerField.setText(usedCpuPower + " GHz / " + this.getComputerCpuPower() + " GHz");
        this.cpuPowerField.setForeground(usedCpuPower > this.getComputerCpuPower() ? TangoColors.SCARLET_3 : Color.BLACK);
        this.cpuPowerField.setEnabled(used);
        this.memoryField.setText(usedMemory + " GB / " + this.getComputerMemory() + " GB");
        this.memoryField.setForeground(usedMemory > this.getComputerMemory() ? TangoColors.SCARLET_3 : Color.BLACK);
        this.memoryField.setEnabled(used);
        this.networkBandwidthField.setText(usedNetworkBandwidth + " GB / " + this.getComputerNetworkBandwidth() + " GB");
        this.networkBandwidthField.setForeground(usedNetworkBandwidth > this.getComputerNetworkBandwidth() ? TangoColors.SCARLET_3 : Color.BLACK);
        this.networkBandwidthField.setEnabled(used);
        this.costField.setEnabled(used);
    }

    private void updateBars(boolean used) {
        this.numberOfProcessesLabel.setText("    " + this.processList.size() + " processes");
        this.numberOfProcessesLabel.setEnabled(used);
        this.cpuPowerBar.setEnabled(used);
        this.cpuPowerBar.repaint();
        this.memoryBar.setEnabled(used);
        this.memoryBar.repaint();
        this.networkBandwidthBar.setEnabled(used);
        this.networkBandwidthBar.repaint();
        this.detailsButton.setEnabled(used);
    }

    private class CloudProcessListDialog
    extends JDialog {
        public CloudProcessListDialog() {
            this.setModal(true);
            this.setTitle(CloudComputerPanel.this.getComputerLabel());
            JPanel contentPanel = new JPanel();
            GroupLayout layout = new GroupLayout(contentPanel);
            contentPanel.setLayout(layout);
            JPanel headerPanel = this.createHeaderPanel();
            JPanel assignmentsPanel = this.createAssignmentsPanel();
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(assignmentsPanel));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(assignmentsPanel, -2, -2, -2));
            JScrollPane contentScrollPane = new JScrollPane(contentPanel);
            contentScrollPane.setPreferredSize(new Dimension(800, 200));
            contentScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setContentPane(contentScrollPane);
            this.pack();
        }

        private JPanel createHeaderPanel() {
            JPanel headerPanel = new JPanel(new GridLayout(0, 5));
            headerPanel.add(new JLabel(""));
            JLabel cpuPowerLabel = new JLabel("CPU power");
            headerPanel.add(cpuPowerLabel);
            JLabel memoryLabel = new JLabel("Memory");
            headerPanel.add(memoryLabel);
            JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
            headerPanel.add(networkBandwidthLabel);
            headerPanel.add(new JLabel(""));
            return headerPanel;
        }

        private JPanel createAssignmentsPanel() {
            JPanel assignmentsPanel = new JPanel(new GridLayout(0, 5));
            int colorIndex = 0;
            for (CloudProcess process : CloudComputerPanel.this.processList) {
                JLabel processLabel = new JLabel(process.getLabel());
                processLabel.setForeground(TangoColors.SEQUENCE_1[colorIndex]);
                assignmentsPanel.add(processLabel);
                JTextField cpuPowerField = new JTextField(process.getRequiredCpuPower() + " GHz");
                cpuPowerField.setEditable(false);
                assignmentsPanel.add(cpuPowerField);
                JTextField memoryField = new JTextField(process.getRequiredMemory() + " GB");
                memoryField.setEditable(false);
                assignmentsPanel.add(memoryField);
                JTextField networkBandwidthField = new JTextField(process.getRequiredNetworkBandwidth() + " GB");
                networkBandwidthField.setEditable(false);
                assignmentsPanel.add(networkBandwidthField);
                assignmentsPanel.add(new JLabel(""));
                colorIndex = (colorIndex + 1) % TangoColors.SEQUENCE_1.length;
            }
            return assignmentsPanel;
        }
    }

    private static class CloudBar
    extends JPanel {
        private List<Integer> processValues = new ArrayList<Integer>();
        private int computerValue;
        private int maximumComputerValue;

        public CloudBar(int computerValue, int maximumComputerValue) {
            this.computerValue = computerValue;
            this.maximumComputerValue = maximumComputerValue;
        }

        public void clearProcessValues() {
            this.processValues.clear();
        }

        public void addProcessValue(int processValue) {
            this.processValues.add(processValue);
        }

        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            int maximumComputerWidth = size.width - 10;
            if (maximumComputerWidth <= 10) {
                g.setColor(TangoColors.ALUMINIUM_6);
                g.drawString("?", 2, 2);
                return;
            }
            double pixelsPerValue = (double)maximumComputerWidth / (double)this.maximumComputerValue;
            int computerWidth = (int)(pixelsPerValue * (double)this.computerValue);
            if (this.computerValue > 0) {
                g.setColor(this.isEnabled() ? Color.WHITE : this.getBackground());
                g.fillRect(0, 0, computerWidth, size.height);
            }
            int offsetValue = 0;
            int colorIndex = 0;
            for (int processValue : this.processValues) {
                int offset = (int)((double)offsetValue * pixelsPerValue);
                int processWidth = (int)((double)processValue * pixelsPerValue) + 1;
                processWidth = Math.max(processWidth, 1);
                g.setColor(TangoColors.SEQUENCE_1[colorIndex]);
                g.fillRect(offset, 0, processWidth, size.height);
                offsetValue += processValue;
                colorIndex = (colorIndex + 1) % TangoColors.SEQUENCE_1.length;
            }
            if (this.computerValue > 0) {
                g.setColor(this.isEnabled() ? Color.BLACK : TangoColors.ALUMINIUM_5);
                g.drawRect(0, 0, computerWidth, size.height - 1);
            }
        }
    }
}

