/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.api.domain.variable.PlanningValueStrengthWeightFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class PeriodStrengthWeightFactory
implements PlanningValueStrengthWeightFactory {
    public Comparable createStrengthWeight(Solution solution, Object planningValue) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)solution;
        Period period = (Period)planningValue;
        int unavailablePeriodPenaltyCount = 0;
        for (UnavailablePeriodPenalty penalty : schedule.getUnavailablePeriodPenaltyList()) {
            if (!penalty.getPeriod().equals(period)) continue;
            ++unavailablePeriodPenaltyCount;
        }
        return new PeriodStrengthWeight(period, unavailablePeriodPenaltyCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PeriodStrengthWeight
    implements Comparable<PeriodStrengthWeight> {
        private final Period period;
        private final int unavailablePeriodPenaltyCount;

        public PeriodStrengthWeight(Period period, int unavailablePeriodPenaltyCount) {
            this.period = period;
            this.unavailablePeriodPenaltyCount = unavailablePeriodPenaltyCount;
        }

        @Override
        public int compareTo(PeriodStrengthWeight other) {
            return new CompareToBuilder().append(other.unavailablePeriodPenaltyCount, this.unavailablePeriodPenaltyCount).append(this.period.getDay().getDayIndex(), other.period.getDay().getDayIndex()).append(this.period.getTimeslot().getTimeslotIndex(), other.period.getTimeslot().getTimeslotIndex()).append((Object)this.period.getId(), (Object)other.period.getId()).toComparison();
        }
    }
}

