/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.solver.score;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.core.score.buildin.simple.DefaultSimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;
import org.drools.planner.examples.nqueens.domain.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NQueensBasicIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<NQueens> {
    private List<Queen> insertedQueenList;
    private int score;

    public void resetWorkingSolution(NQueens nQueens) {
        this.insertedQueenList = new ArrayList<Queen>(nQueens.getN());
        this.score = 0;
        for (Queen queen : nQueens.getQueenList()) {
            this.insert(queen);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((Queen)entity);
    }

    public void beforeAllVariablesChanged(Object entity) {
        this.retract((Queen)entity);
    }

    public void afterAllVariablesChanged(Object entity) {
        this.insert((Queen)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Queen)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Queen)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((Queen)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(Queen queen) {
        Row row = queen.getRow();
        if (row != null) {
            for (Queen otherQueen : this.insertedQueenList) {
                if (queen.getRowIndex() == otherQueen.getRowIndex()) {
                    --this.score;
                }
                if (queen.getAscendingDiagonalIndex() == otherQueen.getAscendingDiagonalIndex()) {
                    --this.score;
                }
                if (queen.getDescendingDiagonalIndex() != otherQueen.getDescendingDiagonalIndex()) continue;
                --this.score;
            }
            this.insertedQueenList.add(queen);
        }
    }

    private void retract(Queen queen) {
        Row row = queen.getRow();
        if (row != null) {
            this.insertedQueenList.remove(queen);
            for (Queen otherQueen : this.insertedQueenList) {
                if (queen.getRowIndex() == otherQueen.getRowIndex()) {
                    ++this.score;
                }
                if (queen.getAscendingDiagonalIndex() == otherQueen.getAscendingDiagonalIndex()) {
                    ++this.score;
                }
                if (queen.getDescendingDiagonalIndex() != otherQueen.getDescendingDiagonalIndex()) continue;
                ++this.score;
            }
        }
    }

    public SimpleScore calculateScore() {
        return DefaultSimpleScore.valueOf((int)this.score);
    }
}

