/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.hardandsoft.DefaultHardAndSoftScore;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.pas.domain.AdmissionPart;
import org.drools.planner.examples.pas.domain.Bed;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.domain.PatientAdmissionSchedule;
import org.drools.planner.examples.pas.domain.Room;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatientAdmissionScheduleSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean checkSameBedInSameNight = true;

    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        PatientAdmissionSchedule patientAdmissionSchedule = (PatientAdmissionSchedule)scoreDirector.getWorkingSolution();
        this.initializeBedDesignationList(scoreDirector, patientAdmissionSchedule);
    }

    private void initializeBedDesignationList(ScoreDirector scoreDirector, PatientAdmissionSchedule patientAdmissionSchedule) {
        List<BedDesignation> bedDesignationList = this.createBedDesignationList(patientAdmissionSchedule);
        HashMap bedToTakenNightIndexSetMap = null;
        if (this.checkSameBedInSameNight) {
            bedToTakenNightIndexSetMap = new HashMap(patientAdmissionSchedule.getBedList().size());
        }
        ArrayList<Bed> bedListInPriority = new ArrayList<Bed>(patientAdmissionSchedule.getBedList());
        for (BedDesignation bedDesignation : bedDesignationList) {
            Score unscheduledScore = scoreDirector.calculateScore();
            int firstNightIndex = bedDesignation.getAdmissionPart().getFirstNight().getIndex();
            int lastNightIndex = bedDesignation.getAdmissionPart().getLastNight().getIndex();
            boolean perfectMatch = false;
            DefaultHardAndSoftScore bestScore = DefaultHardAndSoftScore.valueOf((int)Integer.MIN_VALUE);
            Bed bestBed = null;
            boolean added = false;
            for (Bed bed : bedListInPriority) {
                if (this.checkSameBedInSameNight) {
                    boolean taken = false;
                    Set takenNightIndexSet = (Set)bedToTakenNightIndexSetMap.get(bed);
                    if (takenNightIndexSet != null) {
                        for (int i = firstNightIndex; i <= lastNightIndex; ++i) {
                            if (!takenNightIndexSet.contains(i)) continue;
                            taken = true;
                            break;
                        }
                    }
                    if (taken) continue;
                }
                if (!added) {
                    scoreDirector.beforeEntityAdded((Object)bedDesignation);
                    bedDesignation.setBed(bed);
                    scoreDirector.afterEntityAdded((Object)bedDesignation);
                    added = true;
                } else {
                    scoreDirector.beforeVariableChanged((Object)bedDesignation, "bed");
                    bedDesignation.setBed(bed);
                    scoreDirector.afterVariableChanged((Object)bedDesignation, "bed");
                }
                Score score = scoreDirector.calculateScore();
                if (score.compareTo((Object)unscheduledScore) < 0) {
                    if (score.compareTo((Object)bestScore) > 0) {
                        bestScore = score;
                        bestBed = bed;
                    }
                } else {
                    if (score.equals(unscheduledScore)) {
                        perfectMatch = true;
                        bestScore = score;
                        bestBed = bed;
                        break;
                    }
                    throw new IllegalStateException("The score (" + score + ") cannot be higher than unscheduledScore (" + unscheduledScore + ").");
                }
                if (!perfectMatch) continue;
                break;
            }
            if (bestBed == null) {
                if (this.checkSameBedInSameNight) {
                    throw new IllegalArgumentException("The initializer could not locate an allowed and empty bed for admissionPart (" + bedDesignation.getAdmissionPart() + ").");
                }
                throw new IllegalArgumentException("The initializer could not locate an allowed bed for admissionPart (" + bedDesignation.getAdmissionPart() + ").");
            }
            if (this.checkSameBedInSameNight) {
                HashSet<Integer> takenNightIndexSet = (HashSet<Integer>)bedToTakenNightIndexSetMap.get(bestBed);
                if (takenNightIndexSet == null) {
                    takenNightIndexSet = new HashSet<Integer>(patientAdmissionSchedule.getNightList().size());
                    bedToTakenNightIndexSetMap.put(bestBed, takenNightIndexSet);
                }
                if (takenNightIndexSet != null) {
                    for (int i = firstNightIndex; i <= lastNightIndex; ++i) {
                        boolean unique = takenNightIndexSet.add(i);
                        if (unique) continue;
                        throw new IllegalStateException("The takenNightIndexSet cannot possibly already have nightIndex (" + i + ").");
                    }
                }
            }
            if (!perfectMatch) {
                scoreDirector.beforeVariableChanged((Object)bedDesignation, "bed");
                bedDesignation.setBed(bestBed);
                scoreDirector.afterVariableChanged((Object)bedDesignation, "bed");
            }
            bedListInPriority.remove(bestBed);
            bedListInPriority.add(bestBed);
        }
        Collections.sort(bedDesignationList, new PersistableIdComparator());
        patientAdmissionSchedule.setBedDesignationList(bedDesignationList);
    }

    private List<BedDesignation> createBedDesignationList(PatientAdmissionSchedule patientAdmissionSchedule) {
        ArrayList<BedDesignationInitializationWeight> initializationWeightList = new ArrayList<BedDesignationInitializationWeight>(patientAdmissionSchedule.getAdmissionPartList().size());
        for (AdmissionPart admissionPart : patientAdmissionSchedule.getAdmissionPartList()) {
            BedDesignation bedDesignation = new BedDesignation();
            bedDesignation.setId(admissionPart.getId());
            bedDesignation.setAdmissionPart(admissionPart);
            int disallowedCount = 0;
            for (Room room : patientAdmissionSchedule.getRoomList()) {
                disallowedCount += room.getCapacity() * room.countDisallowedAdmissionPart(admissionPart);
            }
            initializationWeightList.add(new BedDesignationInitializationWeight(bedDesignation, bedDesignation.getAdmissionPart().getNightCount(), disallowedCount));
        }
        Collections.sort(initializationWeightList);
        ArrayList<BedDesignation> bedDesignationList = new ArrayList<BedDesignation>(patientAdmissionSchedule.getAdmissionPartList().size());
        for (BedDesignationInitializationWeight bedDesignationInitializationWeight : initializationWeightList) {
            bedDesignationList.add(bedDesignationInitializationWeight.getBedDesignation());
        }
        return bedDesignationList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BedDesignationInitializationWeight
    implements Comparable<BedDesignationInitializationWeight> {
        private BedDesignation bedDesignation;
        private int nightCount;
        private int disallowedCount;

        private BedDesignationInitializationWeight(BedDesignation bedDesignation, int nightCount, int disallowedCount) {
            this.bedDesignation = bedDesignation;
            this.nightCount = nightCount;
            this.disallowedCount = disallowedCount;
        }

        public BedDesignation getBedDesignation() {
            return this.bedDesignation;
        }

        @Override
        public int compareTo(BedDesignationInitializationWeight other) {
            if (this.nightCount < other.nightCount) {
                return 1;
            }
            if (this.nightCount > other.nightCount) {
                return -1;
            }
            if (this.disallowedCount < other.disallowedCount) {
                return 1;
            }
            if (this.disallowedCount > other.disallowedCount) {
                return -1;
            }
            return 0;
        }
    }
}

