/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.solver.move.ExaminationMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomChangeMove
implements Move {
    private Exam exam;
    private Room toRoom;

    public RoomChangeMove(Exam exam, Room toRoom) {
        this.exam = exam;
        this.toRoom = toRoom;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.exam.getRoom(), (Object)this.toRoom);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new RoomChangeMove(this.exam, this.exam.getRoom());
    }

    public void doMove(ScoreDirector scoreDirector) {
        ExaminationMoveHelper.moveRoom(scoreDirector, this.exam, this.toRoom);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.exam);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toRoom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RoomChangeMove) {
            RoomChangeMove other = (RoomChangeMove)o;
            return new EqualsBuilder().append((Object)this.exam, (Object)other.exam).append((Object)this.toRoom, (Object)other.toRoom).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.exam).append((Object)this.toRoom).toHashCode();
    }

    public String toString() {
        return this.exam + " => " + this.toRoom;
    }
}

