/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.File;
import org.drools.planner.benchmark.core.XStreamProblemIO;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XStreamSolutionDaoImpl
implements SolutionDao {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private XStreamProblemIO xStreamProblemIO;
    private String dirName;
    private File dataDir;

    public XStreamSolutionDaoImpl(String dirName, Class ... xstreamAnnotations) {
        this.dirName = dirName;
        this.dataDir = new File("data/" + dirName);
        this.xStreamProblemIO = new XStreamProblemIO(xstreamAnnotations);
    }

    @Override
    public String getDirName() {
        return this.dirName;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public Solution readSolution(File inputSolutionFile) {
        Solution solution = this.xStreamProblemIO.read(inputSolutionFile);
        this.postRead(solution);
        this.logger.info("Loaded: {}", (Object)inputSolutionFile);
        return solution;
    }

    protected void postRead(Solution solution) {
    }

    @Override
    public void writeSolution(Solution solution, File outputSolutionFile) {
        this.xStreamProblemIO.write(solution, outputSolutionFile);
        this.logger.info("Saved: {}", (Object)outputSolutionFile);
    }
}

