/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class ShiftAssignmentSwapMove
implements Move {
    private ShiftAssignment leftShiftAssignment;
    private ShiftAssignment rightShiftAssignment;

    public ShiftAssignmentSwapMove(ShiftAssignment leftShiftAssignment, ShiftAssignment rightShiftAssignment) {
        this.leftShiftAssignment = leftShiftAssignment;
        this.rightShiftAssignment = rightShiftAssignment;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftShiftAssignment.getEmployee(), (Object)this.rightShiftAssignment.getEmployee());
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new ShiftAssignmentSwapMove(this.rightShiftAssignment, this.leftShiftAssignment);
    }

    public void doMove(ScoreDirector scoreDirector) {
        Employee oldLeftEmployee = this.leftShiftAssignment.getEmployee();
        Employee oldRightEmployee = this.rightShiftAssignment.getEmployee();
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.leftShiftAssignment, oldRightEmployee);
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.rightShiftAssignment, oldLeftEmployee);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftShiftAssignment, this.rightShiftAssignment);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftShiftAssignment.getEmployee(), this.rightShiftAssignment.getEmployee());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ShiftAssignmentSwapMove) {
            ShiftAssignmentSwapMove other = (ShiftAssignmentSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftShiftAssignment, (Object)other.leftShiftAssignment).append((Object)this.rightShiftAssignment, (Object)other.rightShiftAssignment).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftShiftAssignment).append((Object)this.rightShiftAssignment).toHashCode();
    }

    public String toString() {
        return this.leftShiftAssignment + " <=> " + this.rightShiftAssignment;
    }
}

