/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.machinereassignment.solver.selector;

import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.machinereassignment.domain.MachineReassignment;
import org.drools.planner.examples.machinereassignment.domain.MrMachine;
import org.drools.planner.examples.machinereassignment.domain.MrProcess;
import org.drools.planner.examples.machinereassignment.domain.MrProcessAssignment;
import org.drools.planner.examples.machinereassignment.domain.MrResource;

public class MrMachineProbabilityWeightFactory
implements SelectionProbabilityWeightFactory<MrProcessAssignment> {
    public double createProbabilityWeight(ScoreDirector scoreDirector, MrProcessAssignment processAssignment) {
        MachineReassignment machineReassignment = (MachineReassignment)scoreDirector.getWorkingSolution();
        MrMachine machine = processAssignment.getMachine();
        long[] usage = new long[machineReassignment.getResourceList().size()];
        for (MrProcessAssignment someProcessAssignment : machineReassignment.getProcessAssignmentList()) {
            if (someProcessAssignment.getMachine() != machine) continue;
            MrProcess process = someProcessAssignment.getProcess();
            for (MrResource resource : machineReassignment.getResourceList()) {
                int n = resource.getIndex();
                usage[n] = usage[n] + process.getUsage(resource);
            }
        }
        double sum = 0.0;
        for (MrResource resource : machineReassignment.getResourceList()) {
            double available = machine.getMachineCapacity(resource).getSafetyCapacity() - usage[resource.getIndex()];
            sum += available * available;
        }
        return sum + 1.0;
    }
}

