/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.common.swingui.TangoColors;
import org.drools.planner.examples.pas.domain.Bed;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.domain.Night;
import org.drools.planner.examples.pas.domain.PatientAdmissionSchedule;
import org.drools.planner.examples.pas.solver.move.BedChangeMove;

public class PatientAdmissionSchedulePanel
extends SolutionPanel {
    private static final Color HEADER_COLOR = TangoColors.BUTTER_1;
    private GridLayout gridLayout = new GridLayout(0, 1);

    public PatientAdmissionSchedulePanel() {
        this.setLayout(this.gridLayout);
    }

    private PatientAdmissionSchedule getPatientAdmissionSchedule() {
        return (PatientAdmissionSchedule)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.removeAll();
        PatientAdmissionSchedule patientAdmissionSchedule = (PatientAdmissionSchedule)solution;
        this.gridLayout.setColumns(patientAdmissionSchedule.getNightList().size() + 1);
        JLabel headerCornerLabel = new JLabel("Department_Room_Bed  \\  Night");
        headerCornerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerCornerLabel.setBackground(HEADER_COLOR);
        headerCornerLabel.setOpaque(true);
        this.add(headerCornerLabel);
        for (Night night : patientAdmissionSchedule.getNightList()) {
            JLabel nightLabel = new JLabel(night.toString());
            nightLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            nightLabel.setBackground(HEADER_COLOR);
            nightLabel.setOpaque(true);
            this.add(nightLabel);
        }
        HashMap<Bed, Map<Night, BedNightPanel>> bedNightPanelMap = new HashMap<Bed, Map<Night, BedNightPanel>>();
        for (Bed bed : patientAdmissionSchedule.getBedList()) {
            this.createBedLine(patientAdmissionSchedule, bedNightPanelMap, bed);
        }
        this.createBedLine(patientAdmissionSchedule, bedNightPanelMap, null);
        for (BedDesignation bedDesignation : patientAdmissionSchedule.getBedDesignationList()) {
            for (Night night : patientAdmissionSchedule.getNightList()) {
                if (bedDesignation.getAdmissionPart().getFirstNight().getIndex() > night.getIndex() || night.getIndex() > bedDesignation.getAdmissionPart().getLastNight().getIndex()) continue;
                BedNightPanel bedNightPanel = (BedNightPanel)((Map)bedNightPanelMap.get(bedDesignation.getBed())).get(night);
                bedNightPanel.addBedDesignation(bedDesignation);
            }
        }
    }

    private void createBedLine(PatientAdmissionSchedule patientAdmissionSchedule, Map<Bed, Map<Night, BedNightPanel>> bedNightPanelMap, Bed bed) {
        JLabel bedLabel = new JLabel(bed == null ? "Unassigned" : bed.toString());
        bedLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        bedLabel.setBackground(HEADER_COLOR);
        bedLabel.setOpaque(true);
        this.add(bedLabel);
        HashMap<Night, BedNightPanel> nightPanelMap = new HashMap<Night, BedNightPanel>();
        bedNightPanelMap.put(bed, nightPanelMap);
        for (Night night : patientAdmissionSchedule.getNightList()) {
            BedNightPanel bedNightPanel = new BedNightPanel();
            this.add(bedNightPanel);
            nightPanelMap.put(night, bedNightPanel);
        }
    }

    private class BedDesignationAction
    extends AbstractAction {
        private BedDesignation bedDesignation;

        public BedDesignationAction(BedDesignation bedDesignation) {
            super(bedDesignation.getAdmissionPart().getPatient().getName());
            this.bedDesignation = bedDesignation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<Bed> bedList = PatientAdmissionSchedulePanel.this.getPatientAdmissionSchedule().getBedList();
            JComboBox<Object> bedListField = new JComboBox<Object>(bedList.toArray());
            bedListField.setSelectedItem(this.bedDesignation.getBed());
            listFieldsPanel.add(bedListField);
            int result = JOptionPane.showConfirmDialog(PatientAdmissionSchedulePanel.this.getRootPane(), listFieldsPanel, "Select bed", 2);
            if (result == 0) {
                Bed toBed = (Bed)bedListField.getSelectedItem();
                PatientAdmissionSchedulePanel.this.solutionBusiness.doMove(new BedChangeMove(this.bedDesignation, toBed));
                PatientAdmissionSchedulePanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }

    private class BedNightPanel
    extends JPanel {
        public BedNightPanel() {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addBedDesignation(BedDesignation bedDesignation) {
            JButton button = new JButton(new BedDesignationAction(bedDesignation));
            this.add(button);
        }
    }
}

