/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.api.domain.solution.PlanningSolution;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.Appearance;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.Domicile;
import org.drools.planner.examples.tsp.domain.Visit;

@PlanningSolution
@XStreamAlias(value="TravelingSalesmanTour")
public class TravelingSalesmanTour
extends AbstractPersistable
implements Solution<SimpleScore> {
    private String name;
    private List<City> cityList;
    private List<Domicile> domicileList;
    private List<Visit> visitList;
    private SimpleScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<City> getCityList() {
        return this.cityList;
    }

    public void setCityList(List<City> cityList) {
        this.cityList = cityList;
    }

    public List<Domicile> getDomicileList() {
        return this.domicileList;
    }

    public void setDomicileList(List<Domicile> domicileList) {
        this.domicileList = domicileList;
    }

    @PlanningEntityCollectionProperty
    public List<Visit> getVisitList() {
        return this.visitList;
    }

    public void setVisitList(List<Visit> visitList) {
        this.visitList = visitList;
    }

    public SimpleScore getScore() {
        return this.score;
    }

    public void setScore(SimpleScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.cityList);
        facts.addAll(this.domicileList);
        return facts;
    }

    public TravelingSalesmanTour cloneSolution() {
        TravelingSalesmanTour clone = new TravelingSalesmanTour();
        clone.id = this.id;
        clone.name = this.name;
        clone.cityList = this.cityList;
        clone.domicileList = this.domicileList;
        ArrayList<Visit> clonedVisitList = new ArrayList<Visit>(this.visitList.size());
        HashMap<Long, Visit> idToClonedVisitMap = new HashMap<Long, Visit>(this.visitList.size());
        for (Visit visit : this.visitList) {
            Visit clonedVisit = visit.clone();
            clonedVisitList.add(clonedVisit);
            idToClonedVisitMap.put(clonedVisit.getId(), clonedVisit);
        }
        for (Visit clonedVisit : clonedVisitList) {
            Appearance previousAppearance = clonedVisit.getPreviousAppearance();
            if (!(previousAppearance instanceof Visit)) continue;
            Long previousVisitId = ((Visit)previousAppearance).getId();
            clonedVisit.setPreviousAppearance((Appearance)idToClonedVisitMap.get(previousVisitId));
        }
        clone.visitList = clonedVisitList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof TravelingSalesmanTour)) {
            return false;
        }
        TravelingSalesmanTour other = (TravelingSalesmanTour)o;
        if (this.visitList.size() != other.visitList.size()) {
            return false;
        }
        Iterator<Visit> it = this.visitList.iterator();
        Iterator<Visit> otherIt = other.visitList.iterator();
        while (it.hasNext()) {
            Visit otherVisit;
            Visit visit = it.next();
            if (visit.solutionEquals(otherVisit = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Visit visit : this.visitList) {
            hashCodeBuilder.append(visit.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

