/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.app;

import java.awt.Component;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.drools.planner.core.Solver;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.common.business.SolutionBusiness;
import org.drools.planner.examples.common.persistence.AbstractSolutionExporter;
import org.drools.planner.examples.common.persistence.AbstractSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonApp
extends LoggingMain {
    protected static final Logger logger = LoggerFactory.getLogger(CommonApp.class);
    private SolverAndPersistenceFrame solverAndPersistenceFrame;
    private SolutionBusiness solutionBusiness = this.createSolutionBusiness();

    public static void fixateLookAndFeel() {
        Exception lookAndFeelException;
        String lookAndFeelName = "Metal";
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!lookAndFeelName.equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                return;
            }
            lookAndFeelException = null;
        }
        catch (UnsupportedLookAndFeelException e) {
            lookAndFeelException = e;
        }
        catch (ClassNotFoundException e) {
            lookAndFeelException = e;
        }
        catch (InstantiationException e) {
            lookAndFeelException = e;
        }
        catch (IllegalAccessException e) {
            lookAndFeelException = e;
        }
        logger.warn("Could not switch to lookAndFeel (" + lookAndFeelName + "). Layout might be incorrect.", (Throwable)lookAndFeelException);
    }

    public CommonApp() {
        this.solverAndPersistenceFrame = new SolverAndPersistenceFrame(this.solutionBusiness, this.createSolutionPanel(), this.solutionBusiness.getDirName());
    }

    public void init() {
        this.init(null, true);
    }

    public void init(Component centerForComponent, boolean exitOnClose) {
        this.solverAndPersistenceFrame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        this.solverAndPersistenceFrame.init(centerForComponent);
        this.solverAndPersistenceFrame.setVisible(true);
    }

    public SolutionBusiness createSolutionBusiness() {
        SolutionDao solutionDao = this.createSolutionDao();
        SolutionBusiness solutionBusiness = new SolutionBusiness();
        solutionBusiness.setSolutionDao(solutionDao);
        solutionBusiness.setImporter(this.createSolutionImporter());
        solutionBusiness.setExporter(this.createSolutionExporter());
        solutionBusiness.updateDataDirs();
        solutionBusiness.setSolver(this.createSolver());
        return solutionBusiness;
    }

    protected abstract Solver createSolver();

    protected abstract SolutionPanel createSolutionPanel();

    protected abstract SolutionDao createSolutionDao();

    protected AbstractSolutionImporter createSolutionImporter() {
        return null;
    }

    protected AbstractSolutionExporter createSolutionExporter() {
        return null;
    }
}

