/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractSolutionExporter;
import org.drools.planner.examples.common.persistence.SolutionDao;

public abstract class AbstractTxtSolutionExporter
extends AbstractSolutionExporter {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = ".txt";

    protected AbstractTxtSolutionExporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    @Override
    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public abstract TxtOutputBuilder createTxtOutputBuilder();

    @Override
    public void writeSolution(Solution solution, File outputFile) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
            TxtOutputBuilder txtOutputBuilder = this.createTxtOutputBuilder();
            txtOutputBuilder.setBufferedWriter(bufferedWriter);
            txtOutputBuilder.setSolution(solution);
            txtOutputBuilder.writeSolution();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not write the file (" + outputFile.getName() + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
        this.logger.info("Exported: {}", (Object)outputFile);
    }

    public abstract class TxtOutputBuilder {
        protected BufferedWriter bufferedWriter;

        public void setBufferedWriter(BufferedWriter bufferedWriter) {
            this.bufferedWriter = bufferedWriter;
        }

        public abstract void setSolution(Solution var1);

        public abstract void writeSolution() throws IOException;
    }
}

