/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.persistence;

import java.io.IOException;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.drools.planner.examples.curriculumcourse.domain.CourseSchedule;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.persistence.CurriculumCourseDaoImpl;

public class CurriculumCourseSolutionExporter
extends AbstractTxtSolutionExporter {
    private static final String OUTPUT_FILE_SUFFIX = ".sol";

    public static void main(String[] args) {
        new CurriculumCourseSolutionExporter().convertAll();
    }

    public CurriculumCourseSolutionExporter() {
        super(new CurriculumCourseDaoImpl());
    }

    @Override
    protected String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new CurriculumCourseOutputBuilder();
    }

    public class CurriculumCourseOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private CourseSchedule schedule;

        @Override
        public void setSolution(Solution solution) {
            this.schedule = (CourseSchedule)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            for (Lecture lecture : this.schedule.getLectureList()) {
                this.bufferedWriter.write(lecture.getCourse().getCode() + " r" + lecture.getRoom().getCode() + " " + lecture.getPeriod().getDay().getDayIndex() + " " + lecture.getPeriod().getTimeslot().getTimeslotIndex() + "\r\n");
            }
        }
    }
}

