/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.heuristic.selector.move.factory.MoveListFactory;
import org.drools.planner.core.move.CompositeMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.domain.solver.MovableShiftAssignmentSelectionFilter;
import org.drools.planner.examples.nurserostering.solver.move.EmployeeChangeMove;

public class ShiftAssignmentSequenceSwitchLength2MoveFactory
implements MoveListFactory {
    private MovableShiftAssignmentSelectionFilter filter = new MovableShiftAssignmentSelectionFilter();

    public List<Move> createMoveList(Solution solution) {
        NurseRoster nurseRoster = (NurseRoster)solution;
        List<Employee> employeeList = nurseRoster.getEmployeeList();
        ArrayList<ShiftAssignment> shiftAssignmentList = new ArrayList<ShiftAssignment>(nurseRoster.getShiftAssignmentList());
        Iterator it = shiftAssignmentList.iterator();
        while (it.hasNext()) {
            ShiftAssignment shiftAssignment = (ShiftAssignment)it.next();
            if (this.filter.accept(nurseRoster, shiftAssignment)) continue;
            it.remove();
        }
        HashMap employeeToAssignmentSequenceListMap = new HashMap(employeeList.size());
        int assignmentSequenceCapacity = nurseRoster.getShiftDateList().size() + 0;
        for (Employee employee : employeeList) {
            employeeToAssignmentSequenceListMap.put(employee, new ArrayList(assignmentSequenceCapacity));
        }
        for (ShiftAssignment shiftAssignment : shiftAssignmentList) {
            Employee employee = shiftAssignment.getEmployee();
            List assignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(employee);
            if (assignmentSequenceList.isEmpty()) {
                AssignmentSequence assignmentSequence = new AssignmentSequence(shiftAssignment);
                assignmentSequenceList.add(assignmentSequence);
                continue;
            }
            AssignmentSequence lastAssignmentSequence = (AssignmentSequence)assignmentSequenceList.get(assignmentSequenceList.size() - 1);
            if (lastAssignmentSequence.belongsHere(shiftAssignment)) {
                lastAssignmentSequence.add(shiftAssignment);
                continue;
            }
            AssignmentSequence assignmentSequence = new AssignmentSequence(shiftAssignment);
            assignmentSequenceList.add(assignmentSequence);
        }
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<Employee> leftEmployeeIt = employeeList.listIterator();
        while (leftEmployeeIt.hasNext()) {
            Employee leftEmployee = leftEmployeeIt.next();
            List leftAssignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(leftEmployee);
            ListIterator<Employee> rightEmployeeIt = employeeList.listIterator(leftEmployeeIt.nextIndex());
            while (rightEmployeeIt.hasNext()) {
                Employee rightEmployee = rightEmployeeIt.next();
                List rightAssignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(rightEmployee);
                int SWITCH_LENGTH = 2;
                for (AssignmentSequence leftAssignmentSequence : leftAssignmentSequenceList) {
                    List<ShiftAssignment> leftShiftAssignmentList = leftAssignmentSequence.getShiftAssignmentList();
                    for (int leftIndex = 0; leftIndex <= leftShiftAssignmentList.size() - 2; ++leftIndex) {
                        for (AssignmentSequence rightAssignmentSequence : rightAssignmentSequenceList) {
                            List<ShiftAssignment> rightShiftAssignmentList = rightAssignmentSequence.getShiftAssignmentList();
                            for (int rightIndex = 0; rightIndex <= rightShiftAssignmentList.size() - 2; ++rightIndex) {
                                ArrayList<EmployeeChangeMove> subMoveList = new ArrayList<EmployeeChangeMove>(4);
                                for (ShiftAssignment leftShiftAssignment : leftShiftAssignmentList.subList(leftIndex, leftIndex + 2)) {
                                    subMoveList.add(new EmployeeChangeMove(leftShiftAssignment, rightEmployee));
                                }
                                for (ShiftAssignment rightShiftAssignment : rightShiftAssignmentList.subList(rightIndex, rightIndex + 2)) {
                                    subMoveList.add(new EmployeeChangeMove(rightShiftAssignment, leftEmployee));
                                }
                                moveList.add((Move)new CompositeMove(subMoveList));
                            }
                        }
                    }
                }
            }
        }
        return moveList;
    }

    private static class AssignmentSequence {
        private List<ShiftAssignment> shiftAssignmentList = new ArrayList<ShiftAssignment>();
        private int firstDayIndex;
        private int lastDayIndex;

        private AssignmentSequence(ShiftAssignment shiftAssignment) {
            this.shiftAssignmentList.add(shiftAssignment);
            this.lastDayIndex = this.firstDayIndex = shiftAssignment.getShiftDateDayIndex();
        }

        public List<ShiftAssignment> getShiftAssignmentList() {
            return this.shiftAssignmentList;
        }

        public int getFirstDayIndex() {
            return this.firstDayIndex;
        }

        public int getLastDayIndex() {
            return this.lastDayIndex;
        }

        private void add(ShiftAssignment shiftAssignment) {
            this.shiftAssignmentList.add(shiftAssignment);
            int dayIndex = shiftAssignment.getShiftDateDayIndex();
            if (dayIndex < this.lastDayIndex) {
                throw new IllegalStateException("The shiftAssignmentList is expected to be sorted by shiftDate.");
            }
            this.lastDayIndex = dayIndex;
        }

        private boolean belongsHere(ShiftAssignment shiftAssignment) {
            return shiftAssignment.getShiftDateDayIndex() <= this.lastDayIndex + 1;
        }
    }
}

