/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.domain.Patient;
import org.drools.planner.examples.pas.domain.PatientAdmissionSchedule;
import org.drools.planner.examples.pas.persistence.PatientAdmissionScheduleDaoImpl;

public class PatientAdmissionScheduleSolutionExporter
extends AbstractTxtSolutionExporter {
    public static void main(String[] args) {
        new PatientAdmissionScheduleSolutionExporter().convertAll();
    }

    public PatientAdmissionScheduleSolutionExporter() {
        super(new PatientAdmissionScheduleDaoImpl());
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new PatientAdmissionScheduleOutputBuilder();
    }

    public class PatientAdmissionScheduleOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private PatientAdmissionSchedule patientAdmissionSchedule;

        @Override
        public void setSolution(Solution solution) {
            this.patientAdmissionSchedule = (PatientAdmissionSchedule)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            Collections.sort(this.patientAdmissionSchedule.getBedDesignationList(), new Comparator<BedDesignation>(){

                @Override
                public int compare(BedDesignation a, BedDesignation b) {
                    return new CompareToBuilder().append((Object)a.getAdmissionPart(), (Object)b.getAdmissionPart()).append((Object)a.getBed(), (Object)b.getBed()).append((Object)a.getId(), (Object)b.getId()).toComparison();
                }
            });
            for (Patient patient : this.patientAdmissionSchedule.getPatientList()) {
                this.bufferedWriter.write(Long.toString(patient.getId()));
                for (BedDesignation bedDesignation : this.patientAdmissionSchedule.getBedDesignationList()) {
                    if (!bedDesignation.getPatient().equals(patient)) continue;
                    for (int i = 0; i < bedDesignation.getAdmissionPart().getNightCount(); ++i) {
                        this.bufferedWriter.write(" " + Long.toString(bedDesignation.getBed().getId()));
                    }
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

