/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.solver.score;

import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.drools.planner.examples.tsp.domain.Appearance;
import org.drools.planner.examples.tsp.domain.Domicile;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.domain.Visit;

public class TspIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<TravelingSalesmanTour> {
    private Domicile domicile;
    private int score;

    public void resetWorkingSolution(TravelingSalesmanTour tour) {
        if (tour.getDomicileList().size() != 1) {
            throw new UnsupportedOperationException("The domicileList (" + tour.getDomicileList() + ") should be a singleton.");
        }
        this.domicile = tour.getDomicileList().get(0);
        this.score = 0;
        for (Visit visit : tour.getVisitList()) {
            this.insert(visit);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((Visit)entity);
    }

    public void beforeAllVariablesChanged(Object entity) {
        this.retract((Visit)entity);
    }

    public void afterAllVariablesChanged(Object entity) {
        this.insert((Visit)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Visit)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Visit)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((Visit)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(Visit visit) {
        Appearance previousAppearance = visit.getPreviousAppearance();
        if (previousAppearance != null) {
            this.score -= visit.getDistanceToPreviousAppearance();
            this.score += this.domicile.getCity().getDistance(previousAppearance.getCity());
            this.score -= this.domicile.getCity().getDistance(visit.getCity());
        }
    }

    private void retract(Visit visit) {
        Appearance previousAppearance = visit.getPreviousAppearance();
        if (previousAppearance != null) {
            this.score += visit.getDistanceToPreviousAppearance();
            this.score -= this.domicile.getCity().getDistance(previousAppearance.getCity());
            this.score += this.domicile.getCity().getDistance(visit.getCity());
        }
    }

    public SimpleScore calculateScore() {
        return SimpleScore.valueOf((int)this.score);
    }
}

