/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.webexamples.vehiclerouting;

import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpSession;
import org.drools.planner.config.XmlSolverFactory;
import org.drools.planner.core.Solver;
import org.drools.planner.core.event.SolverEventListener;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.vehiclerouting.domain.VrpSchedule;
import org.drools.planner.examples.vehiclerouting.persistence.VehicleRoutingSolutionImporter;

public class VrpWebAction {
    private static ExecutorService solvingExecutor = Executors.newFixedThreadPool(4);

    public void setup(HttpSession session) {
        XmlSolverFactory solverFactory = new XmlSolverFactory("/org/drools/planner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        session.setAttribute("vehiclerouting.solver", (Object)solver);
        URL unsolvedSolutionURL = this.getClass().getResource("/org/drools/planner/webexamples/vehiclerouting/A-n33-k6.vrp");
        VrpSchedule unsolvedSolution = (VrpSchedule)new VehicleRoutingSolutionImporter().readSolution(unsolvedSolutionURL);
        session.setAttribute("vehiclerouting.shownSolution", (Object)unsolvedSolution);
    }

    public void solve(HttpSession session) {
        Solver solver = (Solver)session.getAttribute("vehiclerouting.solver");
        VrpSchedule unsolvedSolution = (VrpSchedule)session.getAttribute("vehiclerouting.shownSolution");
        solver.setPlanningProblem((Solution)unsolvedSolution);
        solver.addEventListener((SolverEventListener)new /* Unavailable Anonymous Inner Class!! */);
        solvingExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void terminateEarly(HttpSession session) {
        Solver solver = (Solver)session.getAttribute("vehiclerouting.solver");
        solver.terminateEarly();
    }
}

