/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.drools.solver.examples.common.business.SolutionBusiness;
import org.drools.solver.examples.common.swingui.ConstraintScoreMapDialog;
import org.drools.solver.examples.common.swingui.SolutionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowFrame
extends JFrame {
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolutionBusiness solutionBusiness;
    private SolutionPanel solutionPanel;
    private JLabel resultLabel;
    private ConstraintScoreMapDialog constraintScoreMapDialog;

    public WorkflowFrame(SolutionPanel solutionPanel, String exampleName) {
        super("Drools solver example " + exampleName);
        this.solutionPanel = solutionPanel;
        solutionPanel.setWorkflowFrame(this);
        this.constraintScoreMapDialog = new ConstraintScoreMapDialog(this);
        this.setDefaultCloseOperation(3);
    }

    public void setSolutionBusiness(SolutionBusiness solutionBusiness) {
        this.solutionBusiness = solutionBusiness;
        this.solutionPanel.setSolutionBusiness(solutionBusiness);
        this.constraintScoreMapDialog.setSolutionBusiness(solutionBusiness);
    }

    public void init() {
        this.setContentPane(this.createContentPane());
        this.pack();
    }

    private JPanel createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createButtonPanel(), "North");
        JScrollPane solutionScrollPane = new JScrollPane(this.solutionPanel);
        panel.add((Component)solutionScrollPane, "Center");
        panel.add((Component)this.createScorePanel(), "South");
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(this.createLoadUnsolvedPanel());
        panel.add(this.createLoadSolvedPanel());
        panel.add(this.createProcessingPanel());
        return panel;
    }

    private JComponent createLoadUnsolvedPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        for (File file : this.solutionBusiness.getUnsolvedFileList()) {
            LoadAction action = new LoadAction(file);
            panel.add(new JButton(action));
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        return scrollPane;
    }

    private JComponent createLoadSolvedPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        for (File file : this.solutionBusiness.getSolvedFileList()) {
            LoadAction action = new LoadAction(file);
            panel.add(new JButton(action));
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        return scrollPane;
    }

    private JComponent createProcessingPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        SolveAction solveAction = new SolveAction();
        panel.add(new JButton(solveAction));
        SaveAction saveAction = new SaveAction();
        panel.add(new JButton(saveAction));
        return panel;
    }

    private JPanel createScorePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.resultLabel = new JLabel("No solution loaded yet");
        this.resultLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.resultLabel, "Center");
        JButton constraintScoreMapButton = new JButton(new ShowConstraintScoreMapDialogAction());
        panel.add((Component)constraintScoreMapButton, "East");
        return panel;
    }

    public void updateScreen() {
        this.solutionPanel.resetPanel();
        this.validate();
        this.resultLabel.setText("Score = " + NUMBER_FORMAT.format(this.solutionBusiness.getScore()));
    }

    private class ShowConstraintScoreMapDialogAction
    extends AbstractAction {
        public ShowConstraintScoreMapDialogAction() {
            super("Constraint scores");
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.constraintScoreMapDialog.resetContentPanel();
            WorkflowFrame.this.constraintScoreMapDialog.setVisible(true);
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save as...");
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(WorkflowFrame.this.solutionBusiness.getSolvedDataDir());
            fileChooser.setDialogType(1);
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                public String getDescription() {
                    return "Solver xml files";
                }
            });
            int approved = fileChooser.showOpenDialog(WorkflowFrame.this);
            if (approved == 0) {
                WorkflowFrame.this.solutionBusiness.save(fileChooser.getSelectedFile());
            }
        }
    }

    private class SolveAction
    extends AbstractAction {
        public SolveAction() {
            super("Solve!");
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.solutionBusiness.solve();
            WorkflowFrame.this.updateScreen();
        }
    }

    private class LoadAction
    extends AbstractAction {
        private File file;

        public LoadAction(File file) {
            super("Load " + file.getName());
            this.file = file;
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.solutionBusiness.load(this.file);
            WorkflowFrame.this.updateScreen();
        }
    }
}

