/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.curriculumcourse.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.common.persistence.XstreamSolutionDaoImpl;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Course;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Curriculum;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Day;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Period;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Room;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Teacher;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Timeslot;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.UnavailablePeriodConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumCourseInputConvertor
extends LoggingMain {
    private static final String INPUT_FILE_SUFFIX = ".ctt";
    private static final String OUTPUT_FILE_SUFFIX = ".xml";
    private static final String SPLIT_REGEX = "[\\ \\t]+";
    private final File inputDir = new File("data/itc2007/curriculumcourse/input/");
    private final File outputDir = new File("data/itc2007/curriculumcourse/unsolved/");

    public static void main(String[] args) {
        new CurriculumCourseInputConvertor().convert();
    }

    public void convert() {
        XstreamSolutionDaoImpl solutionDao = new XstreamSolutionDaoImpl();
        File[] inputFiles = this.inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-solver-examples and contain: " + this.inputDir);
        }
        for (File inputFile : inputFiles) {
            String inputFileName = inputFile.getName();
            if (!inputFileName.endsWith(INPUT_FILE_SUFFIX)) continue;
            CurriculumCourseSchedule schedule = this.readCurriculumCourseSchedule(inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - INPUT_FILE_SUFFIX.length()) + OUTPUT_FILE_SUFFIX;
            File outputFile = new File(this.outputDir, outputFileName);
            solutionDao.writeSolution(schedule, outputFile);
        }
    }

    public CurriculumCourseSchedule readCurriculumCourseSchedule(File inputFile) {
        CurriculumCourseSchedule curriculumCourseSchedule;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(inputFile));
            curriculumCourseSchedule = this.readCurriculumCourseSchedule(bufferedReader);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return curriculumCourseSchedule;
    }

    public CurriculumCourseSchedule readCurriculumCourseSchedule(BufferedReader bufferedReader) throws IOException {
        CurriculumCourseSchedule schedule = new CurriculumCourseSchedule();
        schedule.setId(0L);
        schedule.setName(this.readParam(bufferedReader, "Name:"));
        int courseListSize = Integer.parseInt(this.readParam(bufferedReader, "Courses:"));
        int roomListSize = Integer.parseInt(this.readParam(bufferedReader, "Rooms:"));
        int dayListSize = Integer.parseInt(this.readParam(bufferedReader, "Days:"));
        int timeslotListSize = Integer.parseInt(this.readParam(bufferedReader, "Periods_per_day:"));
        int curriculumListSize = Integer.parseInt(this.readParam(bufferedReader, "Curricula:"));
        int unavailablePeriodConstraintListSize = Integer.parseInt(this.readParam(bufferedReader, "Constraints:"));
        Map<String, Course> courseMap = this.readCourseListAndTeacherList(bufferedReader, schedule, courseListSize);
        this.readRoomList(bufferedReader, schedule, roomListSize);
        Map<List<Integer>, Period> periodMap = this.createPeriodListAndDayListAndTimeslotList(schedule, dayListSize, timeslotListSize);
        this.readCurriculumList(bufferedReader, schedule, courseMap, curriculumListSize);
        this.readUnavailablePeriodConstraintList(bufferedReader, schedule, courseMap, periodMap, unavailablePeriodConstraintListSize);
        this.readHeader(bufferedReader, "END.");
        this.logger.info("CurriculumCourseSchedule with {} teachers, {} curricula, {} courses, {} periods, {} rooms and {} unavailable period constraints.", new Object[]{schedule.getTeacherList().size(), schedule.getCurriculumList().size(), schedule.getCourseList().size(), schedule.getPeriodList().size(), schedule.getRoomList().size(), schedule.getUnavailablePeriodConstraintList().size()});
        return schedule;
    }

    private Map<String, Course> readCourseListAndTeacherList(BufferedReader bufferedReader, CurriculumCourseSchedule schedule, int courseListSize) throws IOException {
        HashMap<String, Course> courseMap = new HashMap<String, Course>(courseListSize);
        HashMap<String, Teacher> teacherMap = new HashMap<String, Teacher>();
        ArrayList<Course> courseList = new ArrayList<Course>(courseListSize);
        this.readHeader(bufferedReader, "COURSES:");
        for (int i = 0; i < courseListSize; ++i) {
            Course course = new Course();
            course.setId(Long.valueOf(i));
            String line = bufferedReader.readLine();
            String[] lineTokens = line.split(SPLIT_REGEX);
            if (lineTokens.length != 5) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 4 tokens.");
            }
            course.setCode(lineTokens[0]);
            course.setTeacher(this.findOrCreateTeacher(teacherMap, lineTokens[1]));
            course.setLectureSize(Integer.parseInt(lineTokens[2]));
            course.setMinWorkingDaySize(Integer.parseInt(lineTokens[3]));
            course.setCurriculumList(new ArrayList<Curriculum>());
            course.setStudentSize(Integer.parseInt(lineTokens[4]));
            courseList.add(course);
            courseMap.put(course.getCode(), course);
        }
        schedule.setCourseList(courseList);
        ArrayList<Teacher> teacherList = new ArrayList<Teacher>(teacherMap.values());
        schedule.setTeacherList(teacherList);
        return courseMap;
    }

    private Teacher findOrCreateTeacher(Map<String, Teacher> teacherMap, String code) {
        Teacher teacher = teacherMap.get(code);
        if (teacher == null) {
            teacher = new Teacher();
            int id = teacherMap.size();
            teacher.setId(Long.valueOf(id));
            teacher.setCode(code);
            teacherMap.put(code, teacher);
        }
        return teacher;
    }

    private void readRoomList(BufferedReader bufferedReader, CurriculumCourseSchedule schedule, int roomListSize) throws IOException {
        this.readHeader(bufferedReader, "ROOMS:");
        ArrayList<Room> roomList = new ArrayList<Room>(roomListSize);
        for (int i = 0; i < roomListSize; ++i) {
            Room room = new Room();
            room.setId(Long.valueOf(i));
            String line = bufferedReader.readLine();
            String[] lineTokens = line.split(SPLIT_REGEX);
            if (lineTokens.length != 2) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 2 tokens.");
            }
            room.setCode(lineTokens[0]);
            room.setCapacity(Integer.parseInt(lineTokens[1]));
            roomList.add(room);
        }
        schedule.setRoomList(roomList);
    }

    private Map<List<Integer>, Period> createPeriodListAndDayListAndTimeslotList(CurriculumCourseSchedule schedule, int dayListSize, int timeslotListSize) throws IOException {
        int periodListSize = dayListSize * timeslotListSize;
        HashMap<List<Integer>, Period> periodMap = new HashMap<List<Integer>, Period>(periodListSize);
        ArrayList<Day> dayList = new ArrayList<Day>(dayListSize);
        for (int i = 0; i < dayListSize; ++i) {
            Day day = new Day();
            day.setId(Long.valueOf(i));
            day.setDayIndex(i);
            dayList.add(day);
        }
        schedule.setDayList(dayList);
        ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(timeslotListSize);
        for (int i = 0; i < timeslotListSize; ++i) {
            Timeslot timeslot = new Timeslot();
            timeslot.setId(Long.valueOf(i));
            timeslot.setTimeslotIndex(i);
            timeslotList.add(timeslot);
        }
        schedule.setTimeslotList(timeslotList);
        ArrayList<Period> periodList = new ArrayList<Period>(periodListSize);
        for (int i = 0; i < dayListSize; ++i) {
            for (int j = 0; j < timeslotListSize; ++j) {
                Period period = new Period();
                period.setId(Long.valueOf(i * timeslotListSize + j));
                period.setDay((Day)dayList.get(i));
                period.setTimeslot((Timeslot)timeslotList.get(j));
                periodList.add(period);
                periodMap.put(Arrays.asList(i, j), period);
            }
        }
        schedule.setPeriodList(periodList);
        return periodMap;
    }

    private void readCurriculumList(BufferedReader bufferedReader, CurriculumCourseSchedule schedule, Map<String, Course> courseMap, int curriculumListSize) throws IOException {
        this.readHeader(bufferedReader, "CURRICULA:");
        ArrayList<Curriculum> curriculumList = new ArrayList<Curriculum>(curriculumListSize);
        for (int i = 0; i < curriculumListSize; ++i) {
            Curriculum curriculum = new Curriculum();
            curriculum.setId(Long.valueOf(i));
            String line = bufferedReader.readLine();
            String[] lineTokens = line.split(SPLIT_REGEX);
            if (lineTokens.length < 2) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain at least 2 tokens.");
            }
            curriculum.setCode(lineTokens[0]);
            int coursesInCurriculum = Integer.parseInt(lineTokens[1]);
            if (lineTokens.length != coursesInCurriculum + 2) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain " + (coursesInCurriculum + 2) + " tokens.");
            }
            for (int j = 2; j < lineTokens.length; ++j) {
                Course course = courseMap.get(lineTokens[j]);
                if (course == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") uses an unexisting course(" + lineTokens[j] + ").");
                }
                course.getCurriculumList().add(curriculum);
            }
            curriculumList.add(curriculum);
        }
        schedule.setCurriculumList(curriculumList);
    }

    private void readUnavailablePeriodConstraintList(BufferedReader bufferedReader, CurriculumCourseSchedule schedule, Map<String, Course> courseMap, Map<List<Integer>, Period> periodMap, int unavailablePeriodConstraintListSize) throws IOException {
        this.readHeader(bufferedReader, "UNAVAILABILITY_CONSTRAINTS:");
        ArrayList<UnavailablePeriodConstraint> constraintList = new ArrayList<UnavailablePeriodConstraint>(unavailablePeriodConstraintListSize);
        for (int i = 0; i < unavailablePeriodConstraintListSize; ++i) {
            UnavailablePeriodConstraint constraint = new UnavailablePeriodConstraint();
            constraint.setId(Long.valueOf(i));
            String line = bufferedReader.readLine();
            String[] lineTokens = line.split(SPLIT_REGEX);
            if (lineTokens.length != 3) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 3 tokens.");
            }
            constraint.setCourse(courseMap.get(lineTokens[0]));
            int dayIndex = Integer.parseInt(lineTokens[1]);
            int timeslotIndex = Integer.parseInt(lineTokens[2]);
            Period period = periodMap.get(Arrays.asList(dayIndex, timeslotIndex));
            if (period == null) {
                throw new IllegalArgumentException("Read line (" + line + ") uses an unexisting period(" + dayIndex + " " + timeslotIndex + ").");
            }
            constraint.setPeriod(period);
            constraintList.add(constraint);
        }
        schedule.setUnavailablePeriodConstraintList(constraintList);
    }

    private String readParam(BufferedReader bufferedReader, String key) throws IOException {
        String line = bufferedReader.readLine();
        String[] lineTokens = line.split(SPLIT_REGEX);
        if (lineTokens.length != 2 || !lineTokens[0].equals(key)) {
            throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 2 tokens" + " and start with \"" + key + "\".");
        }
        return lineTokens[1];
    }

    private void readHeader(BufferedReader bufferedReader, String header) throws IOException {
        String line = bufferedReader.readLine();
        if (line.length() != 0) {
            throw new IllegalArgumentException("Read line (" + line + ") is expected to be empty" + " and be followed with a line \"" + header + "\".");
        }
        line = bufferedReader.readLine();
        if (!line.equals(header)) {
            throw new IllegalArgumentException("Read line (" + line + ") is expected to be \"" + header + "\".");
        }
    }
}

