/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.curriculumcourse.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.common.persistence.XstreamSolutionDaoImpl;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Lecture;

public class CurriculumCourseOutputConvertor
extends LoggingMain {
    private static final String INPUT_FILE_SUFFIX = ".xml";
    private static final String OUTPUT_FILE_SUFFIX = ".sol";
    private final File inputDir = new File("data/itc2007/curriculumcourse/solved/");
    private final File outputDir = new File("data/itc2007/curriculumcourse/output/");

    public static void main(String[] args) {
        new CurriculumCourseOutputConvertor().convert();
    }

    public void convert() {
        XstreamSolutionDaoImpl solutionDao = new XstreamSolutionDaoImpl();
        File[] inputFiles = this.inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-solver-examples and contain: " + this.inputDir);
        }
        for (File inputFile : inputFiles) {
            String inputFileName = inputFile.getName();
            if (!inputFileName.endsWith(INPUT_FILE_SUFFIX)) continue;
            CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)solutionDao.readSolution(inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - INPUT_FILE_SUFFIX.length()) + OUTPUT_FILE_SUFFIX;
            File outputFile = new File(this.outputDir, outputFileName);
            this.writeCurriculumCourseSchedule(schedule, outputFile);
        }
    }

    public void writeCurriculumCourseSchedule(CurriculumCourseSchedule schedule, File outputFile) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(outputFile));
            this.writeExamination(schedule, bufferedWriter);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
    }

    public void writeExamination(CurriculumCourseSchedule schedule, BufferedWriter bufferedWriter) throws IOException {
        for (Lecture lecture : schedule.getLectureList()) {
            bufferedWriter.write(lecture.getCourse().getCode() + " r" + lecture.getRoom().getCode() + " " + lecture.getPeriod().getDay().getDayIndex() + " " + lecture.getPeriod().getTimeslot().getTimeslotIndex() + "\r\n");
        }
    }
}

