/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.curriculumcourse.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Lecture;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Period;
import org.drools.solver.examples.itc2007.curriculumcourse.solver.move.CurriculumCourseMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodChangeMove
implements Move,
TabuPropertyEnabled {
    private Lecture lecture;
    private Period toPeriod;

    public PeriodChangeMove(Lecture lecture, Period toPeriod) {
        this.lecture = lecture;
        this.toPeriod = toPeriod;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.lecture.getPeriod(), (Object)this.toPeriod);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new PeriodChangeMove(this.lecture, this.lecture.getPeriod());
    }

    public void doMove(WorkingMemory workingMemory) {
        CurriculumCourseMoveHelper.movePeriod(workingMemory, this.lecture, this.toPeriod);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.lecture);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PeriodChangeMove) {
            PeriodChangeMove other = (PeriodChangeMove)o;
            return new EqualsBuilder().append((Object)this.lecture, (Object)other.lecture).append((Object)this.toPeriod, (Object)other.toPeriod).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.lecture).append((Object)this.toPeriod).toHashCode();
    }

    public String toString() {
        return this.lecture + " => " + this.toPeriod;
    }
}

