/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.curriculumcourse.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.LocalSearchSolverScope;
import org.drools.solver.core.solution.initializer.AbstractStartingSolutionInitializer;
import org.drools.solver.examples.common.domain.PersistableIdComparator;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Course;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Lecture;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Period;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Room;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.UnavailablePeriodConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumCourseStartingSolutionInitializer
extends AbstractStartingSolutionInitializer {
    public boolean isSolutionInitialized(LocalSearchSolverScope localSearchSolverScope) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)localSearchSolverScope.getWorkingSolution();
        return schedule.isInitialized();
    }

    public void initializeSolution(LocalSearchSolverScope localSearchSolverScope) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)localSearchSolverScope.getWorkingSolution();
        this.initializeLectureList(localSearchSolverScope, schedule);
    }

    private void initializeLectureList(LocalSearchSolverScope localSearchSolverScope, CurriculumCourseSchedule schedule) {
        List<Period> periodList = schedule.getPeriodList();
        List<Room> roomList = schedule.getRoomList();
        WorkingMemory workingMemory = localSearchSolverScope.getWorkingMemory();
        List<Lecture> lectureList = this.createLectureList(schedule);
        for (Lecture lecture : lectureList) {
            PeriodScoring periodScoring;
            double unscheduledScore = localSearchSolverScope.calculateScoreFromWorkingMemory();
            FactHandle lectureHandle = null;
            ArrayList<PeriodScoring> periodScoringList = new ArrayList<PeriodScoring>(periodList.size());
            for (Period period : periodList) {
                if (lectureHandle == null) {
                    lecture.setPeriod(period);
                    lectureHandle = workingMemory.insert((Object)lecture);
                } else {
                    lecture.setPeriod(period);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
                }
                double score = localSearchSolverScope.calculateScoreFromWorkingMemory();
                periodScoringList.add(new PeriodScoring(period, score));
            }
            Collections.sort(periodScoringList);
            boolean almostPerfectMatch = false;
            double bestScore = Double.NEGATIVE_INFINITY;
            Period bestPeriod = null;
            Room bestRoom = null;
            Iterator i$ = periodScoringList.iterator();
            while (i$.hasNext() && !(bestScore >= (periodScoring = (PeriodScoring)i$.next()).getScore())) {
                lecture.setPeriod(periodScoring.getPeriod());
                workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
                for (Room room : roomList) {
                    lecture.setRoom(room);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
                    double score = localSearchSolverScope.calculateScoreFromWorkingMemory();
                    if (score < unscheduledScore) {
                        if (!(score > bestScore)) continue;
                        bestScore = score;
                        bestPeriod = periodScoring.getPeriod();
                        bestRoom = room;
                        continue;
                    }
                    if (!(score >= unscheduledScore)) continue;
                    almostPerfectMatch = true;
                    break;
                }
                if (!almostPerfectMatch) continue;
                break;
            }
            if (!almostPerfectMatch) {
                if (bestPeriod == null || bestRoom == null) {
                    throw new IllegalStateException("The bestPeriod (" + bestPeriod + ") or the bestRoom (" + bestRoom + ") cannot be null.");
                }
                lecture.setPeriod(bestPeriod);
                lecture.setRoom(bestRoom);
                workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
            }
            this.logger.debug("    Lecture ({}) initialized for starting solution.", (Object)lecture);
        }
        Collections.sort(lectureList, new PersistableIdComparator());
        schedule.setLectureList(lectureList);
    }

    public List<Lecture> createLectureList(CurriculumCourseSchedule schedule) {
        List<Course> courseList = schedule.getCourseList();
        ArrayList<CourseInitializationWeight> courseInitializationWeightList = new ArrayList<CourseInitializationWeight>(courseList.size());
        for (Course course : courseList) {
            courseInitializationWeightList.add(new CourseInitializationWeight(schedule, course));
        }
        Collections.sort(courseInitializationWeightList);
        ArrayList<Lecture> lectureList = new ArrayList<Lecture>(courseList.size() * 5);
        int lectureId = 0;
        for (CourseInitializationWeight courseInitializationWeight : courseInitializationWeightList) {
            Course course = courseInitializationWeight.getCourse();
            for (int i = 0; i < course.getLectureSize(); ++i) {
                Lecture lecture = new Lecture();
                lecture.setId(Long.valueOf(lectureId));
                lecture.setCourse(course);
                lecture.setLectureIndexInCourse(i);
                lectureList.add(lecture);
                ++lectureId;
            }
        }
        return lectureList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PeriodScoring
    implements Comparable<PeriodScoring> {
        private Period period;
        private double score;

        private PeriodScoring(Period period, double score) {
            this.period = period;
            this.score = score;
        }

        public Period getPeriod() {
            return this.period;
        }

        public double getScore() {
            return this.score;
        }

        @Override
        public int compareTo(PeriodScoring other) {
            return -new CompareToBuilder().append(this.score, other.score).toComparison();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CourseInitializationWeight
    implements Comparable<CourseInitializationWeight> {
        private Course course;
        private int unavailablePeriodConstraintCount;

        private CourseInitializationWeight(CurriculumCourseSchedule schedule, Course course) {
            this.course = course;
            this.unavailablePeriodConstraintCount = 0;
            for (UnavailablePeriodConstraint constraint : schedule.getUnavailablePeriodConstraintList()) {
                if (!constraint.getCourse().equals(course)) continue;
                ++this.unavailablePeriodConstraintCount;
            }
        }

        public Course getCourse() {
            return this.course;
        }

        @Override
        public int compareTo(CourseInitializationWeight other) {
            return new CompareToBuilder().append(other.course.getCurriculumList().size(), this.course.getCurriculumList().size()).append(other.unavailablePeriodConstraintCount, this.unavailablePeriodConstraintCount).append(other.course.getLectureSize(), this.course.getLectureSize()).append(other.course.getStudentSize(), this.course.getStudentSize()).append(other.course.getMinWorkingDaySize(), this.course.getMinWorkingDaySize()).append((Object)this.course.getId(), (Object)other.course.getId()).toComparison();
        }
    }
}

