/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.solver.simple.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.travelingtournament.domain.Day;
import org.drools.solver.examples.travelingtournament.domain.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayChangeMove
implements Move,
TabuPropertyEnabled {
    private Match match;
    private Day toDay;

    public DayChangeMove(Match match, Day toDay) {
        this.match = match;
        this.toDay = toDay;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.match.getDay(), (Object)this.toDay);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new DayChangeMove(this.match, this.match.getDay());
    }

    public void doMove(WorkingMemory workingMemory) {
        FactHandle matchHandle = workingMemory.getFactHandle((Object)this.match);
        workingMemory.modifyRetract(matchHandle);
        this.match.setDay(this.toDay);
        workingMemory.modifyInsert(matchHandle, (Object)this.match);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.match);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DayChangeMove) {
            DayChangeMove other = (DayChangeMove)o;
            return new EqualsBuilder().append((Object)this.match, (Object)other.match).append((Object)this.toDay, (Object)other.toDay).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.match).append((Object)this.toDay).toHashCode();
    }

    public String toString() {
        return this.match + " => " + this.toDay;
    }
}

