/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.common.app;

import java.io.File;
import org.drools.solver.core.Solver;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.common.business.SolutionBusiness;
import org.drools.solver.examples.common.persistence.SolutionDao;
import org.drools.solver.examples.common.persistence.XstreamSolutionDaoImpl;
import org.drools.solver.examples.common.swingui.SolutionPanel;
import org.drools.solver.examples.common.swingui.WorkflowFrame;

public abstract class CommonApp
extends LoggingMain {
    private WorkflowFrame workflowFrame = new WorkflowFrame(this.createSolutionBusiness(), this.createSolutionPanel(), this.getExampleDirName());

    public void init() {
        this.workflowFrame.init();
        this.workflowFrame.setVisible(true);
    }

    protected SolutionBusiness createSolutionBusiness() {
        SolutionBusiness solutionBusiness = new SolutionBusiness();
        solutionBusiness.setSolutionDao(this.createSolutionDao());
        solutionBusiness.setDataDir(new File("data/" + this.getExampleDirName()));
        solutionBusiness.setSolver(this.createSolver());
        return solutionBusiness;
    }

    protected SolutionDao createSolutionDao() {
        return new XstreamSolutionDaoImpl();
    }

    protected abstract String getExampleDirName();

    protected abstract Solver createSolver();

    protected abstract SolutionPanel createSolutionPanel();
}

