/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.common.business;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.drools.ClassObjectFilter;
import org.drools.WorkingMemory;
import org.drools.runtime.ObjectFilter;
import org.drools.solver.core.Solver;
import org.drools.solver.core.localsearch.DefaultLocalSearchSolver;
import org.drools.solver.core.localsearch.LocalSearchSolverScope;
import org.drools.solver.core.move.Move;
import org.drools.solver.core.score.Score;
import org.drools.solver.core.score.constraint.ConstraintOccurrence;
import org.drools.solver.core.score.constraint.DoubleConstraintOccurrence;
import org.drools.solver.core.score.constraint.IntConstraintOccurrence;
import org.drools.solver.core.score.constraint.UnweightedConstraintOccurrence;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.business.ScoreDetail;
import org.drools.solver.examples.common.persistence.SolutionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionBusiness {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolutionDao solutionDao;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private volatile Solver solver;
    private LocalSearchSolverScope localSearchSolverScope;

    public void setSolutionDao(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    public void setDataDir(File dataDir) {
        this.unsolvedDataDir = new File(dataDir, "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist. The working directory should be set to drools-solver-examples.");
        }
        this.solvedDataDir = new File(dataDir, "solved");
        if (!this.solvedDataDir.exists()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist. The working directory should be set to drools-solver-examples.");
        }
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public void setSolver(Solver solver) {
        this.solver = solver;
        this.localSearchSolverScope = ((DefaultLocalSearchSolver)solver).getLocalSearchSolverScope();
    }

    public List<File> getUnsolvedFileList() {
        List<File> unsolvedFileList = Arrays.asList(this.unsolvedDataDir.listFiles(new SolverExampleFileFilter()));
        Collections.sort(unsolvedFileList);
        return unsolvedFileList;
    }

    public List<File> getSolvedFileList() {
        List<File> solvedFileList = Arrays.asList(this.solvedDataDir.listFiles(new SolverExampleFileFilter()));
        Collections.sort(solvedFileList);
        return solvedFileList;
    }

    public Solution getSolution() {
        return this.localSearchSolverScope.getWorkingSolution();
    }

    public Score getScore() {
        return this.localSearchSolverScope.calculateScoreFromWorkingMemory();
    }

    public List<ScoreDetail> getScoreDetailList() {
        HashMap<String, ScoreDetail> scoreDetailMap = new HashMap<String, ScoreDetail>();
        WorkingMemory workingMemory = this.localSearchSolverScope.getWorkingMemory();
        if (workingMemory == null) {
            return Collections.emptyList();
        }
        Iterator it = workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (it.hasNext()) {
            double occurenceScore;
            ConstraintOccurrence occurrence = (ConstraintOccurrence)it.next();
            ScoreDetail scoreDetail = (ScoreDetail)scoreDetailMap.get(occurrence.getRuleId());
            if (scoreDetail == null) {
                scoreDetail = new ScoreDetail(occurrence.getRuleId(), occurrence.getConstraintType());
                scoreDetailMap.put(occurrence.getRuleId(), scoreDetail);
            }
            if (occurrence instanceof IntConstraintOccurrence) {
                occurenceScore = ((IntConstraintOccurrence)occurrence).getWeight();
            } else if (occurrence instanceof DoubleConstraintOccurrence) {
                occurenceScore = ((DoubleConstraintOccurrence)occurrence).getWeight();
            } else if (occurrence instanceof UnweightedConstraintOccurrence) {
                occurenceScore = 1.0;
            } else {
                throw new IllegalStateException("Cannot determine occurenceScore of ConstraintOccurence class: " + occurrence.getClass());
            }
            scoreDetail.addOccurenceScore(occurenceScore);
        }
        ArrayList<ScoreDetail> scoreDetailList = new ArrayList<ScoreDetail>(scoreDetailMap.values());
        Collections.sort(scoreDetailList);
        return scoreDetailList;
    }

    public void load(File file) {
        Solution solution = this.solutionDao.readSolution(file);
        this.solver.setStartingSolution(solution);
    }

    public void save(File file) {
        Solution solution = this.localSearchSolverScope.getWorkingSolution();
        this.solutionDao.writeSolution(solution, file);
    }

    public void doMove(Move move) {
        if (!move.isMoveDoable(this.localSearchSolverScope.getWorkingMemory())) {
            this.logger.info("Not doing user move ({}) because it is not doable.", (Object)move);
            return;
        }
        this.logger.info("Doing user move ({}).", (Object)move);
        move.doMove(this.localSearchSolverScope.getWorkingMemory());
    }

    public void solve() {
        this.solver.solve();
        Solution solution = this.solver.getBestSolution();
        this.solver.setStartingSolution(solution);
    }

    public void cancelSolving() {
        this.solver.cancel();
    }

    public class SolverExampleFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory() || file.isHidden()) {
                return false;
            }
            return file.getName().endsWith(".xml");
        }
    }
}

