/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.examination.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.itc2007.examination.domain.Exam;
import org.drools.solver.examples.itc2007.examination.domain.Period;
import org.drools.solver.examples.itc2007.examination.solver.move.ExaminationMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodChangeMove
implements Move,
TabuPropertyEnabled {
    private Exam exam;
    private Period toPeriod;

    public PeriodChangeMove(Exam exam, Period toPeriod) {
        this.exam = exam;
        this.toPeriod = toPeriod;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.exam.getPeriod(), (Object)this.toPeriod);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new PeriodChangeMove(this.exam, this.exam.getPeriod());
    }

    public void doMove(WorkingMemory workingMemory) {
        ExaminationMoveHelper.movePeriod(workingMemory, this.exam, this.toPeriod);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.exam);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PeriodChangeMove) {
            PeriodChangeMove other = (PeriodChangeMove)o;
            return new EqualsBuilder().append((Object)this.exam, (Object)other.exam).append((Object)this.toPeriod, (Object)other.toPeriod).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.exam).append((Object)this.toPeriod).toHashCode();
    }

    public String toString() {
        return this.exam + " => " + this.toPeriod;
    }
}

