/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.examination.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.LocalSearchSolverScope;
import org.drools.solver.core.score.DefaultHardAndSoftScore;
import org.drools.solver.core.score.Score;
import org.drools.solver.core.solution.initializer.AbstractStartingSolutionInitializer;
import org.drools.solver.examples.common.domain.PersistableIdComparator;
import org.drools.solver.examples.itc2007.examination.domain.Exam;
import org.drools.solver.examples.itc2007.examination.domain.Examination;
import org.drools.solver.examples.itc2007.examination.domain.Period;
import org.drools.solver.examples.itc2007.examination.domain.PeriodHardConstraint;
import org.drools.solver.examples.itc2007.examination.domain.PeriodHardConstraintType;
import org.drools.solver.examples.itc2007.examination.domain.Room;
import org.drools.solver.examples.itc2007.examination.domain.Topic;
import org.drools.solver.examples.itc2007.examination.domain.solver.ExamBefore;
import org.drools.solver.examples.itc2007.examination.domain.solver.ExamCoincidence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExaminationStartingSolutionInitializer
extends AbstractStartingSolutionInitializer {
    public boolean isSolutionInitialized(LocalSearchSolverScope localSearchSolverScope) {
        Examination examination = (Examination)localSearchSolverScope.getWorkingSolution();
        return examination.isInitialized();
    }

    public void initializeSolution(LocalSearchSolverScope localSearchSolverScope) {
        Examination examination = (Examination)localSearchSolverScope.getWorkingSolution();
        this.initializeExamList(localSearchSolverScope, examination);
    }

    private void initializeExamList(LocalSearchSolverScope localSearchSolverScope, Examination examination) {
        List<Period> periodList = examination.getPeriodList();
        List<Room> roomList = examination.getRoomList();
        ArrayList<Exam> examList = new ArrayList<Exam>(examination.getTopicList().size());
        WorkingMemory workingMemory = localSearchSolverScope.getWorkingMemory();
        List<ExamInitializationWeight> examInitialWeightList = this.createExamAssigningScoreList(examination);
        for (ExamInitializationWeight examInitialWeight : examInitialWeightList) {
            Score unscheduledScore = localSearchSolverScope.calculateScoreFromWorkingMemory();
            Exam leader = examInitialWeight.getExam();
            FactHandle leaderHandle = null;
            ArrayList<ExamToHandle> examToHandleList = new ArrayList<ExamToHandle>(5);
            if (leader.getExamCoincidence() == null) {
                examToHandleList.add(new ExamToHandle(leader));
            } else {
                for (Exam coincidenceExam : leader.getExamCoincidence().getCoincidenceExamSet()) {
                    examToHandleList.add(new ExamToHandle(coincidenceExam));
                }
            }
            ArrayList<PeriodScoring> periodScoringList = new ArrayList<PeriodScoring>(periodList.size());
            for (Period period : periodList) {
                for (ExamToHandle examToHandle : examToHandleList) {
                    if (examToHandle.getExamHandle() == null) {
                        examToHandle.getExam().setPeriod(period);
                        examToHandle.setExamHandle(workingMemory.insert((Object)examToHandle.getExam()));
                        if (!examToHandle.getExam().isCoincidenceLeader()) continue;
                        leaderHandle = examToHandle.getExamHandle();
                        continue;
                    }
                    workingMemory.modifyRetract(examToHandle.getExamHandle());
                    examToHandle.getExam().setPeriod(period);
                    workingMemory.modifyInsert(examToHandle.getExamHandle(), (Object)examToHandle.getExam());
                }
                Score score = localSearchSolverScope.calculateScoreFromWorkingMemory();
                periodScoringList.add(new PeriodScoring(period, score));
            }
            Collections.sort(periodScoringList);
            this.scheduleLeader(periodScoringList, roomList, localSearchSolverScope, workingMemory, unscheduledScore, examToHandleList, leader, leaderHandle);
            examList.add(leader);
            for (ExamToHandle examToHandle : examToHandleList) {
                Exam exam = examToHandle.getExam();
                if (exam.isCoincidenceLeader()) continue;
                this.scheduleNonLeader(roomList, localSearchSolverScope, workingMemory, exam, examToHandle.getExamHandle());
                examList.add(exam);
            }
        }
        Collections.sort(examList, new PersistableIdComparator());
        examination.setExamList(examList);
    }

    private void scheduleLeader(List<PeriodScoring> periodScoringList, List<Room> roomList, LocalSearchSolverScope localSearchSolverScope, WorkingMemory workingMemory, Score unscheduledScore, List<ExamToHandle> examToHandleList, Exam leader, FactHandle leaderHandle) {
        boolean perfectMatch = false;
        DefaultHardAndSoftScore bestScore = DefaultHardAndSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
        Period bestPeriod = null;
        Room bestRoom = null;
        for (PeriodScoring periodScoring : periodScoringList) {
            if (bestScore.compareTo((Object)periodScoring.getScore()) >= 0) break;
            for (ExamToHandle examToHandle : examToHandleList) {
                workingMemory.modifyRetract(examToHandle.getExamHandle());
                examToHandle.getExam().setPeriod(periodScoring.getPeriod());
                workingMemory.modifyInsert(examToHandle.getExamHandle(), (Object)examToHandle.getExam());
            }
            for (Room room : roomList) {
                workingMemory.modifyRetract(leaderHandle);
                leader.setRoom(room);
                workingMemory.modifyInsert(leaderHandle, (Object)leader);
                Score score = localSearchSolverScope.calculateScoreFromWorkingMemory();
                if (score.compareTo((Object)unscheduledScore) < 0) {
                    if (score.compareTo((Object)bestScore) <= 0) continue;
                    bestScore = score;
                    bestPeriod = periodScoring.getPeriod();
                    bestRoom = room;
                    continue;
                }
                if (score.equals(unscheduledScore)) {
                    perfectMatch = true;
                    break;
                }
                throw new IllegalStateException("The score (" + score + ") cannot be higher than unscheduledScore (" + unscheduledScore + ").");
            }
            if (!perfectMatch) continue;
            break;
        }
        if (!perfectMatch) {
            if (bestPeriod == null || bestRoom == null) {
                throw new IllegalStateException("The bestPeriod (" + bestPeriod + ") or the bestRoom (" + bestRoom + ") cannot be null.");
            }
            workingMemory.modifyRetract(leaderHandle);
            leader.setRoom(bestRoom);
            workingMemory.modifyInsert(leaderHandle, (Object)leader);
            for (ExamToHandle examToHandle : examToHandleList) {
                workingMemory.modifyRetract(examToHandle.getExamHandle());
                examToHandle.getExam().setPeriod(bestPeriod);
                workingMemory.modifyInsert(examToHandle.getExamHandle(), (Object)examToHandle.getExam());
            }
        }
        this.logger.debug("    Exam ({}) initialized for starting solution.", (Object)leader);
    }

    private void scheduleNonLeader(List<Room> roomList, LocalSearchSolverScope localSearchSolverScope, WorkingMemory workingMemory, Exam exam, FactHandle examHandle) {
        if (exam.getRoom() != null) {
            throw new IllegalStateException("Exam (" + exam + ") already has a room.");
        }
        Score unscheduledScore = localSearchSolverScope.calculateScoreFromWorkingMemory();
        boolean perfectMatch = false;
        DefaultHardAndSoftScore bestScore = DefaultHardAndSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
        Room bestRoom = null;
        for (Room room : roomList) {
            workingMemory.modifyRetract(examHandle);
            exam.setRoom(room);
            workingMemory.modifyInsert(examHandle, (Object)exam);
            Score score = localSearchSolverScope.calculateScoreFromWorkingMemory();
            if (score.compareTo((Object)unscheduledScore) < 0) {
                if (score.compareTo((Object)bestScore) <= 0) continue;
                bestScore = score;
                bestRoom = room;
                continue;
            }
            if (score.equals(unscheduledScore)) {
                perfectMatch = true;
                break;
            }
            throw new IllegalStateException("The score (" + score + ") cannot be higher than unscheduledScore (" + unscheduledScore + ").");
        }
        if (!perfectMatch) {
            if (bestRoom == null) {
                throw new IllegalStateException("The bestRoom (" + bestRoom + ") cannot be null.");
            }
            workingMemory.modifyRetract(examHandle);
            exam.setRoom(bestRoom);
            workingMemory.modifyInsert(examHandle, (Object)exam);
        }
        this.logger.debug("    Exam ({}) initialized for starting solution. *", (Object)exam);
    }

    private List<ExamInitializationWeight> createExamAssigningScoreList(Examination examination) {
        List<Exam> examList = this.createExamList(examination);
        ArrayList<ExamInitializationWeight> examInitialWeightList = new ArrayList<ExamInitializationWeight>(examList.size());
        for (Exam exam : examList) {
            if (!exam.isCoincidenceLeader()) continue;
            examInitialWeightList.add(new ExamInitializationWeight(exam));
        }
        Collections.sort(examInitialWeightList);
        return examInitialWeightList;
    }

    public List<Exam> createExamList(Examination examination) {
        List<Topic> topicList = examination.getTopicList();
        ArrayList<Exam> examList = new ArrayList<Exam>(topicList.size());
        HashMap<Topic, Exam> topicToExamMap = new HashMap<Topic, Exam>(topicList.size());
        for (Topic topic : topicList) {
            Exam exam = new Exam();
            exam.setId(topic.getId());
            exam.setTopic(topic);
            examList.add(exam);
            topicToExamMap.put(topic, exam);
        }
        for (PeriodHardConstraint periodHardConstraint : examination.getPeriodHardConstraintList()) {
            if (periodHardConstraint.getPeriodHardConstraintType() == PeriodHardConstraintType.EXAM_COINCIDENCE) {
                Exam leftExam = (Exam)topicToExamMap.get(periodHardConstraint.getLeftSideTopic());
                Exam rightExam = (Exam)topicToExamMap.get(periodHardConstraint.getRightSideTopic());
                LinkedHashSet<Exam> newCoincidenceExamSet = new LinkedHashSet<Exam>(4);
                ExamCoincidence leftExamCoincidence = leftExam.getExamCoincidence();
                if (leftExamCoincidence != null) {
                    newCoincidenceExamSet.addAll(leftExamCoincidence.getCoincidenceExamSet());
                } else {
                    newCoincidenceExamSet.add(leftExam);
                }
                ExamCoincidence rightExamCoincidence = rightExam.getExamCoincidence();
                if (rightExamCoincidence != null) {
                    newCoincidenceExamSet.addAll(rightExamCoincidence.getCoincidenceExamSet());
                } else {
                    newCoincidenceExamSet.add(rightExam);
                }
                ExamCoincidence newExamCoincidence = new ExamCoincidence(newCoincidenceExamSet);
                for (Exam exam : newCoincidenceExamSet) {
                    exam.setExamCoincidence(newExamCoincidence);
                }
                continue;
            }
            if (periodHardConstraint.getPeriodHardConstraintType() != PeriodHardConstraintType.AFTER) continue;
            Exam afterExam = (Exam)topicToExamMap.get(periodHardConstraint.getLeftSideTopic());
            Exam beforeExam = (Exam)topicToExamMap.get(periodHardConstraint.getRightSideTopic());
            ExamBefore examBefore = beforeExam.getExamBefore();
            if (examBefore == null) {
                examBefore = new ExamBefore(new LinkedHashSet<Exam>(2));
                beforeExam.setExamBefore(examBefore);
            }
            examBefore.getAfterExamSet().add(afterExam);
        }
        return examList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PeriodScoring
    implements Comparable<PeriodScoring> {
        private Period period;
        private Score score;

        private PeriodScoring(Period period, Score score) {
            this.period = period;
            this.score = score;
        }

        public Period getPeriod() {
            return this.period;
        }

        public Score getScore() {
            return this.score;
        }

        @Override
        public int compareTo(PeriodScoring other) {
            return -new CompareToBuilder().append((Object)this.score, (Object)other.score).toComparison();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExamInitializationWeight
    implements Comparable<ExamInitializationWeight> {
        private Exam exam;
        private int totalStudentSize;
        private int maximumDuration;

        private ExamInitializationWeight(Exam exam) {
            this.exam = exam;
            this.totalStudentSize = this.calculateTotalStudentSize(exam);
            this.maximumDuration = this.calculateMaximumDuration(exam);
        }

        private int calculateTotalStudentSize(Exam innerExam) {
            int innerTotalStudentSize = 0;
            if (innerExam.getExamCoincidence() == null) {
                innerTotalStudentSize = innerExam.getTopicStudentSize();
            } else {
                for (Exam coincidenceExam : innerExam.getExamCoincidence().getCoincidenceExamSet()) {
                    innerTotalStudentSize += coincidenceExam.getTopicStudentSize();
                }
            }
            if (innerExam.getExamBefore() != null) {
                for (Exam afterExam : innerExam.getExamBefore().getAfterExamSet()) {
                    innerTotalStudentSize += this.calculateTotalStudentSize(afterExam);
                }
            }
            return innerTotalStudentSize;
        }

        private int calculateMaximumDuration(Exam innerExam) {
            int innerMaximumDuration = innerExam.getTopic().getDuration();
            if (innerExam.getExamCoincidence() != null) {
                for (Exam coincidenceExam : innerExam.getExamCoincidence().getCoincidenceExamSet()) {
                    innerMaximumDuration = Math.max(innerMaximumDuration, coincidenceExam.getTopicStudentSize());
                }
            }
            if (innerExam.getExamBefore() != null) {
                for (Exam afterExam : innerExam.getExamBefore().getAfterExamSet()) {
                    innerMaximumDuration = Math.max(innerMaximumDuration, this.calculateMaximumDuration(afterExam));
                }
            }
            return innerMaximumDuration;
        }

        public Exam getExam() {
            return this.exam;
        }

        @Override
        public int compareTo(ExamInitializationWeight other) {
            return new CompareToBuilder().append(other.totalStudentSize, this.totalStudentSize).append(other.maximumDuration, this.maximumDuration).append((Object)this.exam.getId(), (Object)other.exam.getId()).toComparison();
        }
    }

    public static class ExamToHandle {
        private Exam exam;
        private FactHandle examHandle;

        public ExamToHandle(Exam exam) {
            this.exam = exam;
        }

        public Exam getExam() {
            return this.exam;
        }

        public FactHandle getExamHandle() {
            return this.examHandle;
        }

        public void setExamHandle(FactHandle examHandle) {
            this.examHandle = examHandle;
        }
    }
}

