/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.lessonschedule.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.lessonschedule.domain.Lesson;
import org.drools.solver.examples.lessonschedule.domain.Timeslot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeslotChangeMove
implements Move,
TabuPropertyEnabled {
    private Lesson lesson;
    private Timeslot toTimeslot;

    public TimeslotChangeMove(Lesson lesson, Timeslot toTimeslot) {
        this.lesson = lesson;
        this.toTimeslot = toTimeslot;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.lesson.getTimeslot(), (Object)this.toTimeslot);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new TimeslotChangeMove(this.lesson, this.lesson.getTimeslot());
    }

    public void doMove(WorkingMemory workingMemory) {
        FactHandle lessonHandle = workingMemory.getFactHandle((Object)this.lesson);
        workingMemory.modifyRetract(lessonHandle);
        this.lesson.setTimeslot(this.toTimeslot);
        workingMemory.modifyInsert(lessonHandle, (Object)this.lesson);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.lesson);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TimeslotChangeMove) {
            TimeslotChangeMove other = (TimeslotChangeMove)o;
            return new EqualsBuilder().append((Object)this.lesson, (Object)other.lesson).append((Object)this.toTimeslot, (Object)other.toTimeslot).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.lesson).append((Object)this.toTimeslot).toHashCode();
    }

    public String toString() {
        return this.lesson + " => " + this.toTimeslot;
    }
}

