/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.manners2009.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.manners2009.domain.Seat;
import org.drools.solver.examples.manners2009.domain.SeatDesignation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeatDesignationSwitchMove
implements Move,
TabuPropertyEnabled {
    private SeatDesignation leftSeatDesignation;
    private SeatDesignation rightSeatDesignation;

    public SeatDesignationSwitchMove(SeatDesignation leftSeatDesignation, SeatDesignation rightSeatDesignation) {
        this.leftSeatDesignation = leftSeatDesignation;
        this.rightSeatDesignation = rightSeatDesignation;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftSeatDesignation.getSeat(), (Object)this.rightSeatDesignation.getSeat());
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new SeatDesignationSwitchMove(this.rightSeatDesignation, this.leftSeatDesignation);
    }

    public void doMove(WorkingMemory workingMemory) {
        Seat oldLeftSeat = this.leftSeatDesignation.getSeat();
        Seat oldRightSeat = this.rightSeatDesignation.getSeat();
        SeatDesignationSwitchMove.moveSeat(workingMemory, this.leftSeatDesignation, oldRightSeat);
        SeatDesignationSwitchMove.moveSeat(workingMemory, this.rightSeatDesignation, oldLeftSeat);
    }

    private static void moveSeat(WorkingMemory workingMemory, SeatDesignation seatDesignation, Seat toSeat) {
        FactHandle factHandle = workingMemory.getFactHandle((Object)seatDesignation);
        seatDesignation.setSeat(toSeat);
        workingMemory.update((org.drools.runtime.rule.FactHandle)factHandle, (Object)seatDesignation);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftSeatDesignation, this.rightSeatDesignation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SeatDesignationSwitchMove) {
            SeatDesignationSwitchMove other = (SeatDesignationSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftSeatDesignation, (Object)other.leftSeatDesignation).append((Object)this.rightSeatDesignation, (Object)other.rightSeatDesignation).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftSeatDesignation).append((Object)this.rightSeatDesignation).toHashCode();
    }

    public String toString() {
        return this.leftSeatDesignation + " <=> " + this.rightSeatDesignation;
    }
}

