/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.domain.AbstractPersistable;
import org.drools.solver.examples.travelingtournament.domain.Day;
import org.drools.solver.examples.travelingtournament.domain.Match;
import org.drools.solver.examples.travelingtournament.domain.Team;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TravelingTournament
extends AbstractPersistable
implements Solution {
    private List<Day> dayList;
    private List<Team> teamList;
    private List<Match> matchList;

    public List<Day> getDayList() {
        return this.dayList;
    }

    public void setDayList(List<Day> dayList) {
        this.dayList = dayList;
    }

    public List<Team> getTeamList() {
        return this.teamList;
    }

    public void setTeamList(List<Team> teamList) {
        this.teamList = teamList;
    }

    public List<Match> getMatchList() {
        return this.matchList;
    }

    public void setMatchList(List<Match> matchSets) {
        this.matchList = matchSets;
    }

    public int getN() {
        return this.teamList.size();
    }

    public Collection<? extends Object> getFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.dayList);
        facts.addAll(this.teamList);
        facts.addAll(this.matchList);
        return facts;
    }

    public TravelingTournament cloneSolution() {
        TravelingTournament clone = new TravelingTournament();
        clone.id = this.id;
        clone.dayList = this.dayList;
        clone.teamList = this.teamList;
        ArrayList<Match> clonedMatchList = new ArrayList<Match>(this.matchList.size());
        for (Match match : this.matchList) {
            clonedMatchList.add(match.clone());
        }
        clone.matchList = clonedMatchList;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof TravelingTournament)) {
            return false;
        }
        TravelingTournament other = (TravelingTournament)o;
        if (this.matchList.size() != other.matchList.size()) {
            return false;
        }
        Iterator<Match> it = this.matchList.iterator();
        Iterator<Match> otherIt = other.matchList.iterator();
        while (it.hasNext()) {
            Match otherMatch;
            Match match = it.next();
            if (match.solutionEquals(otherMatch = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Match match : this.matchList) {
            hashCodeBuilder.append(match.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

