/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.persistence.smart;

import java.io.File;
import java.util.List;
import org.drools.solver.examples.travelingtournament.domain.Match;
import org.drools.solver.examples.travelingtournament.domain.Team;
import org.drools.solver.examples.travelingtournament.domain.TravelingTournament;
import org.drools.solver.examples.travelingtournament.persistence.TravelingTournamentInputConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartTravelingTournamentInputConvertor
extends TravelingTournamentInputConvertor {
    private final File outputDir = new File("data/travelingtournament/smart/unsolved/");

    public static void main(String[] args) {
        new SmartTravelingTournamentInputConvertor().convert();
    }

    @Override
    protected File getOutputDir() {
        return this.outputDir;
    }

    @Override
    protected void initializeMatchDays(TravelingTournament travelingTournament) {
        int n = travelingTournament.getN();
        for (int i = 0; i < n - 1; ++i) {
            this.initializeMatchPairs(travelingTournament, n - 1, i, i);
        }
        int startA = 1;
        int startB = n - 2;
        while (startA < n - 1) {
            for (int i = 0; i < n - 1; ++i) {
                int a = (startA + i) % (n - 1);
                int b = (startB + i) % (n - 1);
                this.initializeMatchPairs(travelingTournament, a, b, i);
            }
            startA += 2;
            startB -= 2;
        }
    }

    private void initializeMatchPairs(TravelingTournament travelingTournament, int a, int b, int i) {
        if (i % 6 >= 3) {
            int oldA = a;
            a = b;
            b = oldA;
        }
        Team aTeam = travelingTournament.getTeamList().get(a);
        Team bTeam = travelingTournament.getTeamList().get(b);
        Match m1 = this.findMatch(travelingTournament.getMatchList(), aTeam, bTeam);
        m1.setDay(travelingTournament.getDayList().get(i));
        Match m2 = this.findMatch(travelingTournament.getMatchList(), bTeam, aTeam);
        m2.setDay(travelingTournament.getDayList().get(i + travelingTournament.getN() - 1));
    }

    private Match findMatch(List<Match> matchList, Team homeTeam, Team awayTeam) {
        for (Match match : matchList) {
            if (!match.getHomeTeam().equals(homeTeam) || !match.getAwayTeam().equals(awayTeam)) continue;
            return match;
        }
        throw new IllegalStateException("Nothing found for: " + homeTeam + " and " + awayTeam);
    }
}

