/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.persistence.smart;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.common.persistence.XstreamSolutionDaoImpl;
import org.drools.solver.examples.travelingtournament.domain.Day;
import org.drools.solver.examples.travelingtournament.domain.Match;
import org.drools.solver.examples.travelingtournament.domain.Team;
import org.drools.solver.examples.travelingtournament.domain.TravelingTournament;

public class SmartTravelingTournamentOutputConvertor
extends LoggingMain {
    private static final String INPUT_FILE_SUFFIX = ".xml";
    private static final String OUTPUT_FILE_SUFFIX = ".trick.txt";
    private final File inputDir = new File("data/travelingtournament/smart/solved/");
    private final File outputDir = new File("data/travelingtournament/output/");

    public static void main(String[] args) {
        new SmartTravelingTournamentOutputConvertor().convert();
    }

    public void convert() {
        XstreamSolutionDaoImpl solutionDao = new XstreamSolutionDaoImpl();
        File[] inputFiles = this.inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-solver-examples and contain: " + this.inputDir);
        }
        for (File inputFile : inputFiles) {
            String inputFileName = inputFile.getName();
            if (!inputFileName.endsWith(INPUT_FILE_SUFFIX)) continue;
            TravelingTournament travelingTournament = (TravelingTournament)solutionDao.readSolution(inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - INPUT_FILE_SUFFIX.length()) + OUTPUT_FILE_SUFFIX;
            File outputFile = new File(this.outputDir, outputFileName);
            this.writeTravelingTournament(travelingTournament, outputFile);
        }
    }

    public void writeTravelingTournament(TravelingTournament travelingTournament, File outputFile) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(outputFile));
            this.writeTravelingTournament(travelingTournament, bufferedWriter);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
    }

    public void writeTravelingTournament(TravelingTournament travelingTournament, BufferedWriter bufferedWriter) throws IOException {
        int maximumTeamNameLength = 0;
        for (Team team : travelingTournament.getTeamList()) {
            if (team.getName().length() <= maximumTeamNameLength) continue;
            maximumTeamNameLength = team.getName().length();
        }
        for (Team team : travelingTournament.getTeamList()) {
            bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", team.getName()));
        }
        bufferedWriter.write("\n");
        for (Team team : travelingTournament.getTeamList()) {
            bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", team.getName().replaceAll("[\\w\\d]", "-")));
        }
        bufferedWriter.write("\n");
        for (Day day : travelingTournament.getDayList()) {
            for (Team team : travelingTournament.getTeamList()) {
                boolean opponentIsHome = false;
                Team opponentTeam = null;
                for (Match match : travelingTournament.getMatchList()) {
                    if (!match.getDay().equals(day)) continue;
                    if (match.getHomeTeam().equals(team)) {
                        opponentIsHome = false;
                        opponentTeam = match.getAwayTeam();
                        continue;
                    }
                    if (!match.getAwayTeam().equals(team)) continue;
                    opponentIsHome = true;
                    opponentTeam = match.getHomeTeam();
                }
                String opponentName = (opponentIsHome ? "@" : "") + opponentTeam.getName();
                bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", opponentName));
            }
            bufferedWriter.write("\n");
        }
    }
}

