/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.common.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.common.persistence.XstreamSolutionDaoImpl;

public abstract class AbstractInputConvertor
extends LoggingMain {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = ".txt";
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = ".xml";

    protected File getInputDir() {
        return new File("data/" + this.getExampleDirName() + "/input/");
    }

    protected File getOutputDir() {
        return new File("data/" + this.getExampleDirName() + "/unsolved/");
    }

    protected abstract String getExampleDirName();

    protected String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public void convertAll() {
        File inputDir = this.getInputDir();
        File outputDir = this.getOutputDir();
        XstreamSolutionDaoImpl solutionDao = new XstreamSolutionDaoImpl();
        Object[] inputFiles = inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-solver-examples and contain: " + inputDir);
        }
        Arrays.sort(inputFiles);
        for (Object inputFile : inputFiles) {
            String inputFileName = ((File)inputFile).getName();
            if (!inputFileName.endsWith(this.getInputFileSuffix())) continue;
            Solution solution = this.readSolution((File)inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(outputDir, outputFileName);
            solutionDao.writeSolution(solution, outputFile);
        }
    }

    public abstract InputBuilder createInputBuilder();

    public Solution readSolution(File inputFile) {
        Solution solution;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(inputFile));
            InputBuilder inputBuilder = this.createInputBuilder();
            inputBuilder.setBufferedReader(bufferedReader);
            solution = inputBuilder.readSolution();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return solution;
    }

    public abstract class InputBuilder {
        protected BufferedReader bufferedReader;

        public void setBufferedReader(BufferedReader bufferedReader) {
            this.bufferedReader = bufferedReader;
        }

        public abstract Solution readSolution() throws IOException;

        public void readEmptyLine() throws IOException {
            this.readConstantLine("");
        }

        public void readConstantLine(String constantValue) throws IOException {
            String line = this.bufferedReader.readLine();
            String value = line.trim();
            if (!value.equals(constantValue)) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to be a constant value (" + constantValue + ").");
            }
        }

        public int readIntegerValue() throws IOException {
            return this.readIntegerValue("");
        }

        public int readIntegerValue(String prefix) throws IOException {
            return this.readIntegerValue(prefix, "");
        }

        public int readIntegerValue(String prefix, String suffix) throws IOException {
            String line = this.bufferedReader.readLine();
            String value = line.trim();
            if (!value.startsWith(prefix)) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to start with prefix (" + prefix + ").");
            }
            if (!(value = value.substring(prefix.length())).endsWith(suffix)) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to end with suffix (" + suffix + ").");
            }
            value = value.substring(0, value.length() - suffix.length());
            value = value.trim();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain an integer value (" + value + ").", e);
            }
        }
    }
}

