/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.common.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.common.persistence.XstreamSolutionDaoImpl;

public abstract class AbstractOutputConvertor
extends LoggingMain {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = ".xml";
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = ".txt";

    protected File getInputDir() {
        return new File("data/" + this.getExampleDirName() + "/solved/");
    }

    protected File getOutputDir() {
        return new File("data/" + this.getExampleDirName() + "/output/");
    }

    protected abstract String getExampleDirName();

    protected String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public void convertAll() {
        File inputDir = this.getInputDir();
        File outputDir = this.getOutputDir();
        XstreamSolutionDaoImpl solutionDao = new XstreamSolutionDaoImpl();
        Object[] inputFiles = inputDir.listFiles();
        Arrays.sort(inputFiles);
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-solver-examples and contain: " + inputDir);
        }
        for (Object inputFile : inputFiles) {
            String inputFileName = ((File)inputFile).getName();
            if (!inputFileName.endsWith(this.getInputFileSuffix())) continue;
            Solution solution = solutionDao.readSolution((File)inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(outputDir, outputFileName);
            this.writeSolution(solution, outputFile);
        }
    }

    public abstract OutputBuilder createOutputBuilder();

    public void writeSolution(Solution solution, File outputFile) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(outputFile));
            OutputBuilder outputBuilder = this.createOutputBuilder();
            outputBuilder.setBufferedWriter(bufferedWriter);
            outputBuilder.setSolution(solution);
            outputBuilder.writeSolution();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
    }

    public abstract class OutputBuilder {
        protected BufferedWriter bufferedWriter;

        public void setBufferedWriter(BufferedWriter bufferedWriter) {
            this.bufferedWriter = bufferedWriter;
        }

        public abstract void setSolution(Solution var1);

        public abstract void writeSolution() throws IOException;
    }
}

