/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.drools.solver.core.event.BestSolutionChangedEvent;
import org.drools.solver.core.event.SolverEventListener;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.business.SolutionBusiness;
import org.drools.solver.examples.common.swingui.ConstraintScoreMapDialog;
import org.drools.solver.examples.common.swingui.SolutionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowFrame
extends JFrame {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolutionBusiness solutionBusiness;
    private SolutionPanel solutionPanel;
    private ConstraintScoreMapDialog constraintScoreMapDialog;
    private List<Action> loadUnsolvedActionList;
    private List<Action> loadSolvedActionList;
    private Action cancelSolvingAction;
    private Action solveAction;
    private Action saveAction;
    private JProgressBar progressBar;
    private JLabel resultLabel;
    private ShowConstraintScoreMapDialogAction showConstraintScoreMapDialogAction;

    public WorkflowFrame(SolutionBusiness solutionBusiness, SolutionPanel solutionPanel, String exampleName) {
        super("Drools solver example " + exampleName);
        this.solutionBusiness = solutionBusiness;
        this.solutionPanel = solutionPanel;
        solutionPanel.setSolutionBusiness(solutionBusiness);
        solutionPanel.setWorkflowFrame(this);
        this.registerSolverEventListener();
        this.constraintScoreMapDialog = new ConstraintScoreMapDialog(this);
        this.constraintScoreMapDialog.setSolutionBusiness(solutionBusiness);
        this.setDefaultCloseOperation(3);
    }

    private void registerSolverEventListener() {
        this.solutionBusiness.addSolverEventLister(new SolverEventListener(){

            public void bestSolutionChanged(BestSolutionChangedEvent event) {
                final Solution bestSolution = event.getNewBestSolution();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WorkflowFrame.this.resultLabel.setText("Latest best score: " + bestSolution.getScore());
                    }
                });
            }
        });
    }

    public void init() {
        this.setContentPane(this.createContentPane());
        this.pack();
    }

    private JPanel createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createButtonPanel(), "North");
        JScrollPane solutionScrollPane = new JScrollPane(this.solutionPanel);
        panel.add((Component)solutionScrollPane, "Center");
        panel.add((Component)this.createScorePanel(), "South");
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(this.createLoadUnsolvedPanel());
        panel.add(this.createLoadSolvedPanel());
        panel.add(this.createProcessingPanel());
        return panel;
    }

    private JComponent createLoadUnsolvedPanel() {
        this.loadUnsolvedActionList = new ArrayList<Action>();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        for (File file : this.solutionBusiness.getUnsolvedFileList()) {
            LoadAction loadUnsolvedAction = new LoadAction(file);
            this.loadUnsolvedActionList.add(loadUnsolvedAction);
            panel.add(new JButton(loadUnsolvedAction));
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        return scrollPane;
    }

    private JComponent createLoadSolvedPanel() {
        this.loadSolvedActionList = new ArrayList<Action>();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        for (File file : this.solutionBusiness.getSolvedFileList()) {
            LoadAction loadSolvedAction = new LoadAction(file);
            this.loadSolvedActionList.add(loadSolvedAction);
            panel.add(new JButton(loadSolvedAction));
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        return scrollPane;
    }

    private JComponent createProcessingPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        this.solveAction = new SolveAction();
        this.solveAction.setEnabled(false);
        panel.add(new JButton(this.solveAction));
        this.cancelSolvingAction = new CancelSolvingAction();
        this.cancelSolvingAction.setEnabled(false);
        panel.add(new JButton(this.cancelSolvingAction));
        this.saveAction = new SaveAction();
        this.saveAction.setEnabled(false);
        panel.add(new JButton(this.saveAction));
        return panel;
    }

    private void setSolvingState(boolean solving) {
        for (Action action : this.loadUnsolvedActionList) {
            action.setEnabled(!solving);
        }
        for (Action action : this.loadSolvedActionList) {
            action.setEnabled(!solving);
        }
        this.solveAction.setEnabled(!solving);
        this.cancelSolvingAction.setEnabled(solving);
        this.saveAction.setEnabled(!solving);
        this.solutionPanel.setEnabled(!solving);
        this.progressBar.setIndeterminate(solving);
        this.progressBar.setStringPainted(solving);
        this.progressBar.setString(solving ? "Solving..." : null);
        this.showConstraintScoreMapDialogAction.setEnabled(!solving);
    }

    private JPanel createScorePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        panel.add((Component)this.progressBar, "West");
        this.resultLabel = new JLabel("No solution loaded yet");
        this.resultLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.resultLabel, "Center");
        this.showConstraintScoreMapDialogAction = new ShowConstraintScoreMapDialogAction();
        JButton constraintScoreMapButton = new JButton(this.showConstraintScoreMapDialogAction);
        panel.add((Component)constraintScoreMapButton, "East");
        return panel;
    }

    public void updateScreen() {
        this.solutionPanel.resetPanel();
        this.validate();
        this.resultLabel.setText("Score: " + this.solutionBusiness.getScore());
    }

    private class ShowConstraintScoreMapDialogAction
    extends AbstractAction {
        public ShowConstraintScoreMapDialogAction() {
            super("Constraint scores");
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.constraintScoreMapDialog.resetContentPanel();
            WorkflowFrame.this.constraintScoreMapDialog.setVisible(true);
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save as...");
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(WorkflowFrame.this.solutionBusiness.getSolvedDataDir());
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".xml");
                }

                public String getDescription() {
                    return "Solver xml files";
                }
            });
            int approved = fileChooser.showSaveDialog(WorkflowFrame.this);
            if (approved == 0) {
                WorkflowFrame.this.solutionBusiness.save(fileChooser.getSelectedFile());
            }
        }
    }

    private class CancelSolvingAction
    extends AbstractAction {
        public CancelSolvingAction() {
            super("Terminate solving early");
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.solutionBusiness.terminateSolvingEarly();
        }
    }

    private class SolveAction
    extends AbstractAction {
        private ExecutorService solvingExecutor;

        public SolveAction() {
            super("Solve");
            this.solvingExecutor = Executors.newFixedThreadPool(1);
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.setSolvingState(true);
            this.solvingExecutor.submit(new Runnable(){

                public void run() {
                    try {
                        WorkflowFrame.this.solutionBusiness.solve();
                    }
                    catch (Throwable e) {
                        WorkflowFrame.this.logger.error("Solving failed: " + e.getMessage(), e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WorkflowFrame.this.setSolvingState(false);
                            WorkflowFrame.this.updateScreen();
                        }
                    });
                }
            });
        }
    }

    private class LoadAction
    extends AbstractAction {
        private File file;

        public LoadAction(File file) {
            super("Load " + file.getName());
            this.file = file;
        }

        public void actionPerformed(ActionEvent e) {
            WorkflowFrame.this.solutionBusiness.load(this.file);
            WorkflowFrame.this.solveAction.setEnabled(true);
            WorkflowFrame.this.saveAction.setEnabled(true);
            WorkflowFrame.this.updateScreen();
        }
    }
}

