/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.curriculumcourse.persistence;

import java.io.IOException;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.persistence.AbstractOutputConvertor;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.solver.examples.itc2007.curriculumcourse.domain.Lecture;

public class CurriculumCourseOutputConvertor
extends AbstractOutputConvertor {
    private static final String OUTPUT_FILE_SUFFIX = ".sol";

    public static void main(String[] args) {
        new CurriculumCourseOutputConvertor().convertAll();
    }

    protected String getExampleDirName() {
        return "itc2007/curriculumcourse";
    }

    protected String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    public AbstractOutputConvertor.OutputBuilder createOutputBuilder() {
        return new CurriculumCourseOutputBuilder();
    }

    public class CurriculumCourseOutputBuilder
    extends AbstractOutputConvertor.OutputBuilder {
        private CurriculumCourseSchedule schedule;

        public void setSolution(Solution solution) {
            this.schedule = (CurriculumCourseSchedule)solution;
        }

        public void writeSolution() throws IOException {
            for (Lecture lecture : this.schedule.getLectureList()) {
                this.bufferedWriter.write(lecture.getCourse().getCode() + " r" + lecture.getRoom().getCode() + " " + lecture.getPeriod().getDay().getDayIndex() + " " + lecture.getPeriod().getTimeslot().getTimeslotIndex() + "\r\n");
            }
        }
    }
}

