/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.examination.app;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.solver.config.XmlSolverConfigurer;
import org.drools.solver.core.Solver;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.app.LoggingMain;
import org.drools.solver.examples.itc2007.examination.domain.Examination;
import org.drools.solver.examples.itc2007.examination.persistence.ExaminationInputConvertor;
import org.drools.solver.examples.itc2007.examination.persistence.ExaminationOutputConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExaminationShellApp
extends LoggingMain {
    public static final String SOLVER_CONFIG = "/org/drools/solver/examples/itc2007/examination/solver/examinationSolverConfig.xml";
    private ExaminationInputConvertor examinationInputConvertor = new ExaminationInputConvertor();
    private ExaminationOutputConvertor examinationOutputConvertor = new ExaminationOutputConvertor();
    private Solver solver;
    private File inputDir;
    private File outputDir;

    public static void main(String[] args) {
        long maximumSecondsSpend;
        if (args.length != 1) {
            System.out.println("Use exactly 1 program argument (maximumSecondsSpend). Exiting...");
            System.exit(1);
        }
        try {
            maximumSecondsSpend = Long.parseLong(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("The program argument maximumSecondsSpend (" + args[0] + ") is not a number." + " Exiting...");
            System.exit(1);
            maximumSecondsSpend = 0L;
        }
        new ExaminationShellApp(maximumSecondsSpend).processs();
    }

    private ExaminationShellApp(long maximumSecondsSpend) {
        this.configureSolver(maximumSecondsSpend);
        this.configureDataDir();
    }

    private void configureSolver(long maximumSecondsSpend) {
        XmlSolverConfigurer configurer = new XmlSolverConfigurer();
        configurer.configure(SOLVER_CONFIG);
        configurer.getConfig().getTerminationConfig().setMaximumSecondsSpend(Long.valueOf(maximumSecondsSpend));
        this.solver = configurer.buildSolver();
    }

    private void configureDataDir() {
        File dataDir = new File("data/itc2007/examination/");
        this.inputDir = new File(dataDir, "input");
        if (!this.inputDir.exists()) {
            throw new IllegalStateException("The directory inputDir (" + this.inputDir.getAbsolutePath() + ") does not exist. The working directory should be set to the script directory" + " or to drools-solver-examples.");
        }
        this.outputDir = new File(dataDir, "output");
        if (!this.outputDir.exists()) {
            throw new IllegalStateException("The directory outputDir (" + this.outputDir.getAbsolutePath() + ") does not exist. The working directory should be set to the script directory" + " or to drools-solver-examples.");
        }
    }

    private void processs() {
        List<File> inputFileList = this.getInputFileList();
        for (File inputFile : inputFileList) {
            Examination examination = (Examination)this.examinationInputConvertor.readSolution(inputFile);
            this.solver.setStartingSolution((Solution)examination);
            this.solver.solve();
            examination = (Examination)this.solver.getBestSolution();
            File outputFile = this.getOutputFile(inputFile);
            this.examinationOutputConvertor.writeSolution(examination, outputFile);
        }
    }

    public List<File> getInputFileList() {
        List<File> inputFileList = Arrays.asList(this.inputDir.listFiles(new ExamInputFileFilter()));
        Collections.sort(inputFileList);
        return inputFileList;
    }

    private File getOutputFile(File inputFile) {
        String outputFileName = inputFile.getName().replaceAll("\\.exam$", ".sln");
        return new File(this.outputDir, outputFileName);
    }

    public class ExamInputFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory() || file.isHidden()) {
                return false;
            }
            return file.getName().endsWith(".exam");
        }
    }
}

