/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.itc2007.examination.persistence;

import java.io.IOException;
import java.util.Collections;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.domain.PersistableIdComparator;
import org.drools.solver.examples.common.persistence.AbstractOutputConvertor;
import org.drools.solver.examples.itc2007.examination.domain.Exam;
import org.drools.solver.examples.itc2007.examination.domain.Examination;

public class ExaminationOutputConvertor
extends AbstractOutputConvertor {
    private static final String OUTPUT_FILE_SUFFIX = ".sln";

    public static void main(String[] args) {
        new ExaminationOutputConvertor().convertAll();
    }

    protected String getExampleDirName() {
        return "itc2007/examination";
    }

    protected String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    public AbstractOutputConvertor.OutputBuilder createOutputBuilder() {
        return new ExaminationOutputBuilder();
    }

    public class ExaminationOutputBuilder
    extends AbstractOutputConvertor.OutputBuilder {
        private Examination examination;

        public void setSolution(Solution solution) {
            this.examination = (Examination)solution;
        }

        public void writeSolution() throws IOException {
            Collections.sort(this.examination.getExamList(), new PersistableIdComparator());
            for (Exam exam : this.examination.getExamList()) {
                this.bufferedWriter.write(exam.getPeriod().getId() + ", " + exam.getRoom().getId() + "\r\n");
            }
        }
    }
}

