/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.lessonschedule.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.solver.examples.common.swingui.SolutionPanel;
import org.drools.solver.examples.lessonschedule.domain.Lesson;
import org.drools.solver.examples.lessonschedule.domain.LessonSchedule;
import org.drools.solver.examples.lessonschedule.domain.Timeslot;
import org.drools.solver.examples.lessonschedule.solver.move.TimeslotChangeMove;

public class LessonSchedulePanel
extends SolutionPanel {
    public LessonSchedulePanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    private LessonSchedule getLessonSchedule() {
        return (LessonSchedule)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        TimeslotPanel timeslotPanel;
        this.removeAll();
        LessonSchedule lessonSchedule = this.getLessonSchedule();
        HashMap<Timeslot, TimeslotPanel> timeslotPanelMap = new HashMap<Timeslot, TimeslotPanel>();
        for (Timeslot timeslot : lessonSchedule.getTimeslotList()) {
            timeslotPanel = new TimeslotPanel();
            this.add(timeslotPanel);
            timeslotPanelMap.put(timeslot, timeslotPanel);
        }
        for (Lesson lesson : lessonSchedule.getLessonList()) {
            timeslotPanel = (TimeslotPanel)timeslotPanelMap.get(lesson.getTimeslot());
            timeslotPanel.addLesson(lesson);
        }
    }

    private class LessonAction
    extends AbstractAction {
        private Lesson lesson;

        public LessonAction(Lesson lesson) {
            super(lesson.toString());
            this.lesson = lesson;
        }

        public void actionPerformed(ActionEvent e) {
            List<Timeslot> timeslotList = LessonSchedulePanel.this.getLessonSchedule().getTimeslotList();
            JComboBox<Object> timeslotListField = new JComboBox<Object>(timeslotList.toArray());
            timeslotListField.setSelectedItem(this.lesson.getTimeslot());
            int result = JOptionPane.showConfirmDialog(LessonSchedulePanel.this.getRootPane(), timeslotListField, "Select timeslot", 2);
            if (result == 0) {
                Timeslot toTimeslot = (Timeslot)timeslotListField.getSelectedItem();
                TimeslotChangeMove move = new TimeslotChangeMove(this.lesson, toTimeslot);
                LessonSchedulePanel.this.solutionBusiness.doMove(move);
                LessonSchedulePanel.this.workflowFrame.updateScreen();
            }
        }
    }

    private class TimeslotPanel
    extends JPanel {
        public TimeslotPanel() {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }

        public void addLesson(Lesson lesson) {
            JButton button = new JButton(new LessonAction(lesson));
            this.add(button);
        }
    }
}

