/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.nqueens.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.solver.examples.common.swingui.SolutionPanel;
import org.drools.solver.examples.nqueens.domain.NQueens;
import org.drools.solver.examples.nqueens.domain.Queen;
import org.drools.solver.examples.nqueens.solver.move.YChangeMove;

public class NQueensPanel
extends SolutionPanel {
    private static final String QUEEN_IMAGE_PATH = "/org/drools/solver/examples/nqueens/swingui/queenImage.png";
    private ImageIcon queenImageIcon;

    public NQueensPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.queenImageIcon = new ImageIcon(this.getClass().getResource(QUEEN_IMAGE_PATH));
    }

    private NQueens getNQueens() {
        return (NQueens)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        this.removeAll();
        NQueens nQueens = this.getNQueens();
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        this.setLayout(new GridLayout(n, n));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Queen queen = queenList.get(j);
                if (queen.getY() == i) {
                    JButton button = new JButton(new QueenAction(queen));
                    button.setHorizontalTextPosition(0);
                    button.setVerticalTextPosition(3);
                    this.add(button);
                    continue;
                }
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                Color background = (i + j) % 2 == 0 ? Color.WHITE : Color.GRAY;
                panel.setBackground(background);
                this.add(panel);
            }
        }
    }

    private class QueenAction
    extends AbstractAction {
        private Queen queen;

        public QueenAction(Queen queen) {
            super("[" + queen.getId() + "]", NQueensPanel.this.queenImageIcon);
            this.queen = queen;
        }

        public void actionPerformed(ActionEvent e) {
            List<Integer> yList = NQueensPanel.this.getNQueens().createNList();
            JComboBox<Object> yListField = new JComboBox<Object>(yList.toArray());
            yListField.setSelectedItem(this.queen.getY());
            int result = JOptionPane.showConfirmDialog(NQueensPanel.this.getRootPane(), yListField, "Select y", 2);
            if (result == 0) {
                int toY = (Integer)yListField.getSelectedItem();
                YChangeMove move = new YChangeMove(this.queen, toY);
                NQueensPanel.this.solutionBusiness.doMove(move);
                NQueensPanel.this.workflowFrame.updateScreen();
            }
        }
    }
}

