/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.pas.domain;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.solver.examples.common.domain.AbstractPersistable;
import org.drools.solver.examples.pas.domain.AdmissionPart;
import org.drools.solver.examples.pas.domain.Patient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Department
extends AbstractPersistable
implements Comparable<Department> {
    private String name;
    private Integer minimumAge = null;
    private Integer maximumAge = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMinimumAge() {
        return this.minimumAge;
    }

    public void setMinimumAge(Integer minimumAge) {
        this.minimumAge = minimumAge;
    }

    public Integer getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumAge(Integer maximumAge) {
        this.maximumAge = maximumAge;
    }

    @Override
    public int compareTo(Department other) {
        return new CompareToBuilder().append((Object)this.id, (Object)other.id).toComparison();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int countDisallowedAdmissionPart(AdmissionPart admissionPart) {
        return this.countDisallowedPatientAge(admissionPart.getPatient());
    }

    public int countDisallowedPatientAge(Patient patient) {
        int count = 0;
        if (this.minimumAge != null && patient.getAge() < this.minimumAge) {
            count += 10;
        }
        if (this.maximumAge != null && patient.getAge() > this.maximumAge) {
            count += 10;
        }
        return count;
    }
}

