/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.pas.domain;

import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.solver.examples.common.domain.AbstractPersistable;
import org.drools.solver.examples.pas.domain.AdmissionPart;
import org.drools.solver.examples.pas.domain.Department;
import org.drools.solver.examples.pas.domain.Equipment;
import org.drools.solver.examples.pas.domain.Gender;
import org.drools.solver.examples.pas.domain.GenderLimitation;
import org.drools.solver.examples.pas.domain.Patient;
import org.drools.solver.examples.pas.domain.PreferredPatientEquipment;
import org.drools.solver.examples.pas.domain.RequiredPatientEquipment;
import org.drools.solver.examples.pas.domain.RoomEquipment;
import org.drools.solver.examples.pas.domain.RoomSpecialism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Room
extends AbstractPersistable
implements Comparable<Room> {
    private String name;
    private Department department;
    private int capacity;
    private GenderLimitation genderLimitation;
    private List<RoomSpecialism> roomSpecialismList;
    private List<RoomEquipment> roomEquipmentList;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public GenderLimitation getGenderLimitation() {
        return this.genderLimitation;
    }

    public void setGenderLimitation(GenderLimitation genderLimitation) {
        this.genderLimitation = genderLimitation;
    }

    public List<RoomSpecialism> getRoomSpecialismList() {
        return this.roomSpecialismList;
    }

    public void setRoomSpecialismList(List<RoomSpecialism> roomSpecialismList) {
        this.roomSpecialismList = roomSpecialismList;
    }

    public List<RoomEquipment> getRoomEquipmentList() {
        return this.roomEquipmentList;
    }

    public void setRoomEquipmentList(List<RoomEquipment> roomEquipmentList) {
        this.roomEquipmentList = roomEquipmentList;
    }

    @Override
    public int compareTo(Room other) {
        return new CompareToBuilder().append((Object)this.department, (Object)other.department).append((Object)this.id, (Object)other.id).toComparison();
    }

    @Override
    public String toString() {
        return this.department + "_" + this.name;
    }

    public int countDisallowedAdmissionPart(AdmissionPart admissionPart) {
        return this.department.countDisallowedAdmissionPart(admissionPart) + this.countDisallowedPatientGender(admissionPart.getPatient()) + this.countMissingRequiredRoomProperties(admissionPart.getPatient()) + this.countMissingPreferredRoomProperties(admissionPart.getPatient());
    }

    public int countDisallowedPatientGender(Patient patient) {
        switch (this.genderLimitation) {
            case ANY_GENDER: {
                return 0;
            }
            case MALE_ONLY: {
                return patient.getGender() == Gender.MALE ? 0 : 50;
            }
            case FEMALE_ONLY: {
                return patient.getGender() == Gender.FEMALE ? 0 : 50;
            }
            case SAME_GENDER: {
                return 25;
            }
        }
        throw new IllegalStateException("The genderLimitation (" + (Object)((Object)this.genderLimitation) + ") is not implemented");
    }

    public int countMissingRequiredRoomProperties(Patient patient) {
        int count = 0;
        for (RequiredPatientEquipment requiredPatientEquipment : patient.getRequiredPatientEquipmentList()) {
            Equipment requiredEquipment = requiredPatientEquipment.getEquipment();
            boolean hasRequiredEquipment = false;
            for (RoomEquipment roomEquipment : this.roomEquipmentList) {
                if (!roomEquipment.getEquipment().equals(requiredEquipment)) continue;
                hasRequiredEquipment = true;
            }
            if (hasRequiredEquipment) continue;
            count += 50;
        }
        return count;
    }

    public int countMissingPreferredRoomProperties(Patient patient) {
        int count = 0;
        for (PreferredPatientEquipment preferredPatientEquipment : patient.getPreferredPatientEquipmentList()) {
            Equipment preferredEquipment = preferredPatientEquipment.getEquipment();
            boolean hasPreferredEquipment = false;
            for (RoomEquipment roomEquipment : this.roomEquipmentList) {
                if (!roomEquipment.getEquipment().equals(preferredEquipment)) continue;
                hasPreferredEquipment = true;
            }
            if (hasPreferredEquipment) continue;
            count += 20;
        }
        return count;
    }
}

