/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.pas.persistence;

import java.io.IOException;
import java.util.Collections;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.persistence.AbstractOutputConvertor;
import org.drools.solver.examples.pas.domain.BedDesignation;
import org.drools.solver.examples.pas.domain.Patient;
import org.drools.solver.examples.pas.domain.PatientAdmissionSchedule;

public class PatientAdmissionScheduleOutputConvertor
extends AbstractOutputConvertor {
    public static void main(String[] args) {
        new PatientAdmissionScheduleOutputConvertor().convertAll();
    }

    protected String getExampleDirName() {
        return "pas";
    }

    public AbstractOutputConvertor.OutputBuilder createOutputBuilder() {
        return new PatientAdmissionScheduleOutputBuilder();
    }

    public class PatientAdmissionScheduleOutputBuilder
    extends AbstractOutputConvertor.OutputBuilder {
        private PatientAdmissionSchedule patientAdmissionSchedule;

        public PatientAdmissionScheduleOutputBuilder() {
            super(PatientAdmissionScheduleOutputConvertor.this);
        }

        public void setSolution(Solution solution) {
            this.patientAdmissionSchedule = (PatientAdmissionSchedule)solution;
        }

        public void writeSolution() throws IOException {
            Collections.sort(this.patientAdmissionSchedule.getBedDesignationList());
            for (Patient patient : this.patientAdmissionSchedule.getPatientList()) {
                this.bufferedWriter.write(Long.toString(patient.getId()));
                for (BedDesignation bedDesignation : this.patientAdmissionSchedule.getBedDesignationList()) {
                    if (!bedDesignation.getPatient().equals(patient)) continue;
                    for (int i = 0; i < bedDesignation.getAdmissionPart().getNightCount(); ++i) {
                        this.bufferedWriter.write(" " + Long.toString(bedDesignation.getBed().getId()));
                    }
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

