/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.pas.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.pas.domain.Bed;
import org.drools.solver.examples.pas.domain.BedDesignation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BedChangeMove
implements Move,
TabuPropertyEnabled {
    private BedDesignation bedDesignation;
    private Bed toBed;

    public BedChangeMove(BedDesignation bedDesignation, Bed toBed) {
        this.bedDesignation = bedDesignation;
        this.toBed = toBed;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.bedDesignation.getBed(), (Object)this.toBed);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new BedChangeMove(this.bedDesignation, this.bedDesignation.getBed());
    }

    public void doMove(WorkingMemory workingMemory) {
        FactHandle factHandle = workingMemory.getFactHandle((Object)this.bedDesignation);
        this.bedDesignation.setBed(this.toBed);
        workingMemory.update((org.drools.runtime.rule.FactHandle)factHandle, (Object)this.bedDesignation);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.bedDesignation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedChangeMove) {
            BedChangeMove other = (BedChangeMove)o;
            return new EqualsBuilder().append((Object)this.bedDesignation, (Object)other.bedDesignation).append((Object)this.toBed, (Object)other.toBed).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.bedDesignation).append((Object)this.toBed).toHashCode();
    }

    public String toString() {
        return this.bedDesignation + " => " + this.toBed;
    }
}

