/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.pas.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.solver.core.localsearch.decider.accepter.tabu.TabuPropertyEnabled;
import org.drools.solver.core.move.Move;
import org.drools.solver.examples.pas.domain.Bed;
import org.drools.solver.examples.pas.domain.BedDesignation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BedDesignationSwitchMove
implements Move,
TabuPropertyEnabled {
    private BedDesignation leftBedDesignation;
    private BedDesignation rightBedDesignation;

    public BedDesignationSwitchMove(BedDesignation leftBedDesignation, BedDesignation rightBedDesignation) {
        this.leftBedDesignation = leftBedDesignation;
        this.rightBedDesignation = rightBedDesignation;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftBedDesignation.getBed(), (Object)this.rightBedDesignation.getBed());
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new BedDesignationSwitchMove(this.rightBedDesignation, this.leftBedDesignation);
    }

    public void doMove(WorkingMemory workingMemory) {
        Bed oldLeftBed = this.leftBedDesignation.getBed();
        Bed oldRightBed = this.rightBedDesignation.getBed();
        BedDesignationSwitchMove.moveBed(workingMemory, this.leftBedDesignation, oldRightBed);
        BedDesignationSwitchMove.moveBed(workingMemory, this.rightBedDesignation, oldLeftBed);
    }

    private static void moveBed(WorkingMemory workingMemory, BedDesignation bedDesignation, Bed toBed) {
        FactHandle factHandle = workingMemory.getFactHandle((Object)bedDesignation);
        bedDesignation.setBed(toBed);
        workingMemory.update((org.drools.runtime.rule.FactHandle)factHandle, (Object)bedDesignation);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftBedDesignation, this.rightBedDesignation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BedDesignationSwitchMove) {
            BedDesignationSwitchMove other = (BedDesignationSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftBedDesignation, (Object)other.leftBedDesignation).append((Object)this.rightBedDesignation, (Object)other.rightBedDesignation).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftBedDesignation).append((Object)this.rightBedDesignation).toHashCode();
    }

    public String toString() {
        return this.leftBedDesignation + " <=> " + this.rightBedDesignation;
    }
}

