/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.pas.solver.move.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.solver.core.move.CompositeMove;
import org.drools.solver.core.move.Move;
import org.drools.solver.core.move.factory.AbstractMoveFactory;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.pas.domain.Bed;
import org.drools.solver.examples.pas.domain.BedDesignation;
import org.drools.solver.examples.pas.domain.PatientAdmissionSchedule;
import org.drools.solver.examples.pas.solver.move.BedChangeMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BedDesignationPillarPartSwitchMoveFactory
extends AbstractMoveFactory {
    public List<Move> createMoveList(Solution solution) {
        PatientAdmissionSchedule patientAdmissionSchedule = (PatientAdmissionSchedule)solution;
        HashMap<Bed, ArrayList<BedDesignation>> bedToBedDesignationList = new HashMap<Bed, ArrayList<BedDesignation>>(patientAdmissionSchedule.getBedList().size());
        for (BedDesignation bedDesignation : patientAdmissionSchedule.getBedDesignationList()) {
            ArrayList<BedDesignation> bedDesignationListPerBed = (ArrayList<BedDesignation>)bedToBedDesignationList.get(bedDesignation.getBed());
            if (bedDesignationListPerBed == null) {
                bedDesignationListPerBed = new ArrayList<BedDesignation>(patientAdmissionSchedule.getNightList().size());
                bedToBedDesignationList.put(bedDesignation.getBed(), bedDesignationListPerBed);
            }
            bedDesignationListPerBed.add(bedDesignation);
        }
        for (List bedDesignationListPerBed : bedToBedDesignationList.values()) {
            Collections.sort(bedDesignationListPerBed, new Comparator<BedDesignation>(){

                @Override
                public int compare(BedDesignation a, BedDesignation b) {
                    return new CompareToBuilder().append((Object)a.getAdmissionPart().getFirstNight(), (Object)b.getAdmissionPart().getFirstNight()).append((Object)a.getAdmissionPart().getLastNight(), (Object)b.getAdmissionPart().getLastNight()).append((Object)a.getAdmissionPart(), (Object)b.getAdmissionPart()).toComparison();
                }
            });
        }
        List<Bed> bedList = patientAdmissionSchedule.getBedList();
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<Bed> leftBedIt = bedList.listIterator();
        while (leftBedIt.hasNext()) {
            Bed leftBed = leftBedIt.next();
            ListIterator<Bed> rightBedIt = bedList.listIterator(leftBedIt.nextIndex());
            while (rightBedIt.hasNext()) {
                List<BedDesignation> rightBedDesignationList;
                Bed rightBed = rightBedIt.next();
                List<BedDesignation> leftBedDesignationList = (List<BedDesignation>)bedToBedDesignationList.get(leftBed);
                if (leftBedDesignationList == null) {
                    leftBedDesignationList = Collections.emptyList();
                }
                if ((rightBedDesignationList = (List<BedDesignation>)bedToBedDesignationList.get(rightBed)) == null) {
                    rightBedDesignationList = Collections.emptyList();
                }
                LowestFirstNightBedDesignationIterator lowestIt = new LowestFirstNightBedDesignationIterator(leftBedDesignationList, rightBedDesignationList);
                while (lowestIt.hasNext()) {
                    Bed otherBed;
                    BedDesignation pillarPartBedDesignation = lowestIt.next();
                    ArrayList<BedChangeMove> moveListByPillarPartDuo = new ArrayList<BedChangeMove>(leftBedDesignationList.size() + rightBedDesignationList.size());
                    int lastNightIndex = pillarPartBedDesignation.getAdmissionPart().getLastNight().getIndex();
                    int leftMinimumLastNightIndex = Integer.MIN_VALUE;
                    int rightMinimumLastNightIndex = Integer.MIN_VALUE;
                    if (lowestIt.isLastNextWasLeft()) {
                        otherBed = rightBed;
                        leftMinimumLastNightIndex = lastNightIndex;
                    } else {
                        otherBed = leftBed;
                        rightMinimumLastNightIndex = lastNightIndex;
                    }
                    moveListByPillarPartDuo.add(new BedChangeMove(pillarPartBedDesignation, otherBed));
                    while (lowestIt.hasNextWithMaximumFirstNightIndexes(leftMinimumLastNightIndex, rightMinimumLastNightIndex)) {
                        pillarPartBedDesignation = lowestIt.next();
                        lastNightIndex = pillarPartBedDesignation.getAdmissionPart().getLastNight().getIndex();
                        if (lowestIt.isLastNextWasLeft()) {
                            otherBed = rightBed;
                            leftMinimumLastNightIndex = Math.max(leftMinimumLastNightIndex, lastNightIndex);
                        } else {
                            otherBed = leftBed;
                            rightMinimumLastNightIndex = Math.max(rightMinimumLastNightIndex, lastNightIndex);
                        }
                        moveListByPillarPartDuo.add(new BedChangeMove(pillarPartBedDesignation, otherBed));
                    }
                    moveList.add((Move)new CompositeMove(moveListByPillarPartDuo));
                }
            }
        }
        return moveList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LowestFirstNightBedDesignationIterator
    implements Iterator<BedDesignation> {
        private Iterator<BedDesignation> leftIterator;
        private Iterator<BedDesignation> rightIterator;
        private boolean leftHasNext = true;
        private boolean rightHasNext = true;
        private BedDesignation nextLeft;
        private BedDesignation nextRight;
        private boolean lastNextWasLeft;

        public LowestFirstNightBedDesignationIterator(List<BedDesignation> leftBedDesignationList, List<BedDesignation> rightBedDesignationList) {
            this.leftIterator = leftBedDesignationList.iterator();
            if (this.leftIterator.hasNext()) {
                this.nextLeft = this.leftIterator.next();
            } else {
                this.leftHasNext = false;
                this.nextLeft = null;
            }
            this.rightIterator = rightBedDesignationList.iterator();
            if (this.rightIterator.hasNext()) {
                this.nextRight = this.rightIterator.next();
            } else {
                this.rightHasNext = false;
                this.nextRight = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.leftHasNext || this.rightHasNext;
        }

        public boolean hasNextWithMaximumFirstNightIndexes(int leftMinimumLastNightIndex, int rightMinimumLastNightIndex) {
            if (!this.hasNext()) {
                return false;
            }
            boolean nextIsLeft = this.nextIsLeft();
            if (nextIsLeft) {
                int firstNightIndex = this.nextLeft.getAdmissionPart().getFirstNight().getIndex();
                return firstNightIndex > leftMinimumLastNightIndex && firstNightIndex <= rightMinimumLastNightIndex;
            }
            int firstNightIndex = this.nextRight.getAdmissionPart().getFirstNight().getIndex();
            return firstNightIndex > rightMinimumLastNightIndex && firstNightIndex <= leftMinimumLastNightIndex;
        }

        @Override
        public BedDesignation next() {
            BedDesignation lowest;
            this.lastNextWasLeft = this.nextIsLeft();
            if (this.lastNextWasLeft) {
                lowest = this.nextLeft;
                if (this.leftIterator.hasNext()) {
                    this.nextLeft = this.leftIterator.next();
                } else {
                    this.leftHasNext = false;
                    this.nextLeft = null;
                }
            } else {
                lowest = this.nextRight;
                if (this.rightIterator.hasNext()) {
                    this.nextRight = this.rightIterator.next();
                } else {
                    this.rightHasNext = false;
                    this.nextRight = null;
                }
            }
            return lowest;
        }

        private boolean nextIsLeft() {
            boolean returnLeft;
            if (this.leftHasNext) {
                int rightFirstNightIndex;
                int leftFirstNightIndex;
                returnLeft = this.rightHasNext ? (leftFirstNightIndex = this.nextLeft.getAdmissionPart().getFirstNight().getIndex()) < (rightFirstNightIndex = this.nextRight.getAdmissionPart().getFirstNight().getIndex()) : true;
            } else if (this.rightHasNext) {
                returnLeft = false;
            } else {
                throw new NoSuchElementException();
            }
            return returnLeft;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }

        public boolean isLastNextWasLeft() {
            return this.lastNextWasLeft;
        }
    }
}

