/*
 * Decompiled with CFR 0.152.
 */
package org.drools.solver.examples.travelingtournament.persistence.smart;

import java.io.File;
import java.io.IOException;
import org.drools.solver.core.solution.Solution;
import org.drools.solver.examples.common.persistence.AbstractOutputConvertor;
import org.drools.solver.examples.travelingtournament.domain.Day;
import org.drools.solver.examples.travelingtournament.domain.Match;
import org.drools.solver.examples.travelingtournament.domain.Team;
import org.drools.solver.examples.travelingtournament.domain.TravelingTournament;

public class SmartTravelingTournamentOutputConvertor
extends AbstractOutputConvertor {
    private static final String OUTPUT_FILE_SUFFIX = ".trick.txt";
    private final File inputDir = new File("data/travelingtournament/smart/solved/");

    public static void main(String[] args) {
        new SmartTravelingTournamentOutputConvertor().convertAll();
    }

    protected String getExampleDirName() {
        return "travelingtournament/smart";
    }

    protected File getInputDir() {
        return this.inputDir;
    }

    protected String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    public AbstractOutputConvertor.OutputBuilder createOutputBuilder() {
        return new SmartTravelingTournamentOutputBuilder();
    }

    public class SmartTravelingTournamentOutputBuilder
    extends AbstractOutputConvertor.OutputBuilder {
        private TravelingTournament travelingTournament;

        public void setSolution(Solution solution) {
            this.travelingTournament = (TravelingTournament)solution;
        }

        public void writeSolution() throws IOException {
            int maximumTeamNameLength = 0;
            for (Team team : this.travelingTournament.getTeamList()) {
                if (team.getName().length() <= maximumTeamNameLength) continue;
                maximumTeamNameLength = team.getName().length();
            }
            for (Team team : this.travelingTournament.getTeamList()) {
                this.bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", team.getName()));
            }
            this.bufferedWriter.write("\n");
            for (Team team : this.travelingTournament.getTeamList()) {
                this.bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", team.getName().replaceAll("[\\w\\d]", "-")));
            }
            this.bufferedWriter.write("\n");
            for (Day day : this.travelingTournament.getDayList()) {
                for (Team team : this.travelingTournament.getTeamList()) {
                    boolean opponentIsHome = false;
                    Team opponentTeam = null;
                    for (Match match : this.travelingTournament.getMatchList()) {
                        if (!match.getDay().equals(day)) continue;
                        if (match.getHomeTeam().equals(team)) {
                            opponentIsHome = false;
                            opponentTeam = match.getAwayTeam();
                            continue;
                        }
                        if (!match.getAwayTeam().equals(team)) continue;
                        opponentIsHome = true;
                        opponentTeam = match.getHomeTeam();
                    }
                    String opponentName = (opponentIsHome ? "@" : "") + opponentTeam.getName();
                    this.bufferedWriter.write(String.format("%-" + (maximumTeamNameLength + 3) + "s", opponentName));
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

